/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingMaintainFactory;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class NacosFactory {
    private static ConcurrentHashMap<String, NamingService> cache = new ConcurrentHashMap();

    public static ConfigService createConfigService(Properties properties) throws NacosException {
        return ConfigFactory.createConfigService(properties);
    }

    public static ConfigService createConfigService(String serverAddr) throws NacosException {
        return ConfigFactory.createConfigService(serverAddr);
    }

    public static NamingService createNamingService(String serverAddr) throws NacosException {
        return NamingFactory.createNamingService(serverAddr);
    }

    public static NamingService createNamingService(Properties properties) throws NacosException {
        String key = properties.getOrDefault((Object)"serverAddr", "").toString();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return NamingFactory.createNamingService(properties);
        }
        return cache.compute(key, (k, v) -> {
            if (null == v) {
                try {
                    return NamingFactory.createNamingService(properties);
                }
                catch (NacosException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return v;
        });
    }

    public static NamingMaintainService createMaintainService(String serverAddr) throws NacosException {
        return NamingMaintainFactory.createMaintainService(serverAddr);
    }

    public static NamingMaintainService createMaintainService(Properties properties) throws NacosException {
        return NamingMaintainFactory.createMaintainService(properties);
    }
}

