/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static long dayms = 86400000L;

    public static String getTime() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy.MM.dd");
        return dateTimeFormatter.format(LocalDateTime.now());
    }

    public static String getTime(int plusDays) {
        LocalDate today = LocalDate.now();
        LocalDate tomorrow = today.plusDays(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy.MM.dd");
        return tomorrow.format(formatter);
    }

    public static long getTodayFirstMillisecond() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(sdf.format(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime();
    }

    public static long getYesterdayFirstMillisecond() {
        return DateUtils.getTodayFirstMillisecond() - dayms;
    }

    public static long getBeforeYesterdayFirstMillisecond() {
        return DateUtils.getTodayFirstMillisecond() - dayms * 2L;
    }

    public static Long getThisDayFirstMillisecond(String thisDay) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = format.parse(thisDay);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date.getTime();
    }

    public static String getDaysAgo(int n) {
        return new SimpleDateFormat("yyyy-MM-dd").format(System.currentTimeMillis() - (long)n * dayms);
    }

    public static String timeStamp2Date(String millSeconds, String format) {
        if (StringUtils.isBlank((CharSequence)millSeconds)) {
            return "";
        }
        if (format == null || format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(Long.valueOf(millSeconds)));
    }
}

