/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.parse.FieldInterceptor;
import org.apache.ozhera.log.parse.LogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogParser
implements LogParser {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogParser.class);
    protected LogParserData parserData;
    private List<FieldInterceptor> fieldInterceptors = Lists.newArrayList();

    public AbstractLogParser(LogParserData parserData) {
        this.parserData = parserData;
        this.createFieldInterceptors();
    }

    private void createFieldInterceptors() {
        try {
            Set implementationClasses = ClassUtil.scanPackageBySuper((String)"com.xiaomi.mone.log", FieldInterceptor.class);
            this.fieldInterceptors = implementationClasses.stream().map(x$0 -> ReflectUtil.newInstance((Class)x$0, (Object[])new Object[0])).filter(obj -> obj instanceof FieldInterceptor).map(obj -> (FieldInterceptor)obj).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("createFieldInterceptors", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> parse(String logData, String ip, Long lineNum, Long collectStamp, String fileName) {
        Map<String, Object> parseData = this.doParse(logData, ip, lineNum, collectStamp, fileName);
        this.extractTimeStamp(parseData, logData, collectStamp);
        this.wrapMap(parseData, this.parserData, ip, lineNum, fileName, collectStamp);
        this.checkMessageExist(parseData, logData);
        this.validRet(parseData, logData);
        this.fieldInterceptors.forEach(fieldInterceptor -> fieldInterceptor.postProcess(parseData));
        return parseData;
    }

    @Override
    public Map<String, Object> parseSimple(String logData, Long collectStamp) {
        Map<String, Object> parseData = this.doParseSimple(logData, collectStamp);
        this.fieldInterceptors.stream().forEach(fieldInterceptor -> fieldInterceptor.postProcess(parseData));
        return parseData;
    }

    protected void validTimestamp(Map<String, Object> ret, Long collectStamp) {
        if (ret.containsKey("timestamp")) {
            Long time = this.getTimestampFromString(ret.get("timestamp").toString(), collectStamp);
            ret.put("timestamp", time);
        }
    }

    void extractTimeStamp(Map<String, Object> ret, String logData, Long collectStamp) {
        Long time;
        String timeStamp;
        if (!ret.containsKey("timestamp") && logData.startsWith("[")) {
            timeStamp = StringUtils.substringBetween((String)logData, (String)"[", (String)"]");
            time = this.getTimestampFromString(timeStamp, collectStamp);
            ret.put("timestamp", time);
        }
        if (!ret.containsKey("timestamp") && logData.startsWith("20")) {
            timeStamp = StringUtils.substring((String)logData, (int)0, (int)specialTimeLength);
            time = this.getTimestampFromString(timeStamp, collectStamp);
            ret.put("timestamp", time);
        }
    }

    void wrapMap(Map<String, Object> ret, LogParserData parserData, String ip, Long lineNum, String fileName, Long collectStamp) {
        ret.putIfAbsent("timestamp", null == collectStamp ? this.getTimestampFromString("", collectStamp) : collectStamp);
        ret.put("mqtopic", parserData.getTopicName());
        ret.put("mqtag", parserData.getMqTag());
        ret.put("logstore", parserData.getLogStoreName());
        ret.put("tail", parserData.getTailName());
        ret.put("logip", ip);
        ret.put("linenumber", lineNum);
        ret.put("filename", fileName);
    }

    void checkMessageExist(Map<String, Object> ret, String originData) {
        if (!ret.containsKey("message")) {
            ret.put("message", originData);
            ret.remove("logsource");
        }
    }

    void validRet(Map<String, Object> ret, String logData) {
        if (ret.values().stream().filter(Objects::nonNull).map(String::valueOf).anyMatch(StringUtils::isEmpty)) {
            ret.put("logsource", logData);
        }
    }

    public abstract Map<String, Object> doParse(String var1, String var2, Long var3, Long var4, String var5);

    public abstract Map<String, Object> doParseSimple(String var1, Long var2);
}

