/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.event.listener;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.event.GenericEventListener;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryDestroyedEvent;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryDestroyingEvent;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryInitializedEvent;
import org.apache.dubbo.registry.client.event.ServiceDiscoveryInitializingEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancePreRegisteredEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancePreUnregisteredEvent;
import org.apache.dubbo.registry.client.event.ServiceInstanceRegisteredEvent;
import org.apache.dubbo.registry.client.event.ServiceInstanceUnregisteredEvent;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;

public class LoggingEventListener
extends GenericEventListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onEvent(ServiceDiscoveryInitializingEvent event) {
        this.info("%s is initializing...", event.getServiceDiscovery());
    }

    @Override
    public void onEvent(ServiceDiscoveryInitializedEvent event) {
        this.info("%s is initialized.", event.getServiceDiscovery());
    }

    @Override
    public void onEvent(ServiceInstancePreRegisteredEvent event) {
        this.info("%s is registering into %s...", event.getServiceInstance(), event.getSource());
    }

    @Override
    public void onEvent(ServiceInstanceRegisteredEvent event) {
        this.info("%s has been registered into %s.", event.getServiceInstance(), event.getSource());
    }

    @Override
    public void onEvent(ServiceInstancesChangedEvent event) {
        this.info("The service[name : %s] instances[size : %s] has been changed.", event.getServiceName(), event.getServiceInstances().size());
    }

    @Override
    public void onEvent(ServiceInstancePreUnregisteredEvent event) {
        this.info("%s is unregistering from %s...", event.getServiceInstance(), event.getSource());
    }

    @Override
    public void onEvent(ServiceInstanceUnregisteredEvent event) {
        this.info("%s has been unregistered from %s.", event.getServiceInstance(), event.getSource());
    }

    @Override
    public void onEvent(ServiceDiscoveryDestroyingEvent event) {
        this.info("%s is stopping...", event.getServiceDiscovery());
    }

    @Override
    public void onEvent(ServiceDiscoveryDestroyedEvent event) {
        this.info("%s is stopped.", event.getServiceDiscovery());
    }

    private void info(String pattern, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format(pattern, args));
        }
    }
}

