/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class MethodDefinitionBuilder {
    private final TypeDefinitionBuilder builder;

    public MethodDefinitionBuilder(TypeDefinitionBuilder builder) {
        this.builder = builder;
    }

    public MethodDefinitionBuilder() {
        this.builder = new TypeDefinitionBuilder();
    }

    public MethodDefinition build(Method method) {
        MethodDefinition md = new MethodDefinition();
        md.setName(method.getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        Type[] genericParamTypes = method.getGenericParameterTypes();
        int paramSize = paramTypes.length;
        String[] parameterTypes = new String[paramSize];
        ArrayList<TypeDefinition> parameters = new ArrayList<TypeDefinition>(paramSize);
        for (int i = 0; i < paramSize; ++i) {
            TypeDefinition parameter = this.builder.build(genericParamTypes[i], paramTypes[i]);
            parameterTypes[i] = parameter.getType();
            parameters.add(parameter);
        }
        md.setParameterTypes(parameterTypes);
        md.setParameters(parameters);
        TypeDefinition td = this.builder.build(method.getGenericReturnType(), method.getReturnType());
        md.setReturnType(td.getType());
        return md;
    }
}

