/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.event;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.dubbo.event.EventListener;

public interface Listenable<E extends EventListener<?>> {
    public void addEventListener(E var1) throws NullPointerException, IllegalArgumentException;

    default public void addEventListeners(E listener, E ... others) throws NullPointerException, IllegalArgumentException {
        ArrayList<E> listeners = new ArrayList<E>(1 + others.length);
        listeners.add(listener);
        listeners.addAll(Arrays.asList(others));
        this.addEventListeners(listeners);
    }

    default public void addEventListeners(Iterable<E> listeners) throws NullPointerException, IllegalArgumentException {
        StreamSupport.stream(listeners.spliterator(), false).forEach(this::addEventListener);
    }

    public void removeEventListener(E var1) throws NullPointerException, IllegalArgumentException;

    default public void removeEventListeners(Iterable<E> listeners) throws NullPointerException, IllegalArgumentException {
        StreamSupport.stream(listeners.spliterator(), false).forEach(this::removeEventListener);
    }

    default public void removeAllEventListeners() {
        this.removeEventListeners(this.getAllEventListeners());
    }

    public List<E> getAllEventListeners();

    public static void assertListener(EventListener<?> listener) throws NullPointerException {
        if (listener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        Class<?> listenerClass = listener.getClass();
        int modifiers = listenerClass.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            throw new IllegalArgumentException("The listener must be concrete class");
        }
    }
}

