/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.spring.util.BeanRegistrar;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.apache.dubbo.config.spring.context.DubboBootstrapApplicationListener;
import org.apache.dubbo.config.spring.context.annotation.DubboClassPathBeanDefinitionScanner;
import org.apache.dubbo.config.spring.util.DubboAnnotationUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ServiceClassPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
ResourceLoaderAware,
BeanClassLoaderAware {
    private static final List<Class<? extends Annotation>> serviceAnnotationTypes = Arrays.asList(DubboService.class, org.apache.dubbo.config.annotation.Service.class, Service.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Set<String> packagesToScan;
    private Environment environment;
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public ServiceClassPostProcessor(String ... packagesToScan) {
        this(Arrays.asList(packagesToScan));
    }

    public ServiceClassPostProcessor(Collection<String> packagesToScan) {
        this((Set<String>)new LinkedHashSet<String>(packagesToScan));
    }

    public ServiceClassPostProcessor(Set<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        BeanRegistrar.registerInfrastructureBean((BeanDefinitionRegistry)registry, (String)"dubboBootstrapApplicationListener", DubboBootstrapApplicationListener.class);
        Set<String> resolvedPackagesToScan = this.resolvePackagesToScan(this.packagesToScan);
        if (!CollectionUtils.isEmpty(resolvedPackagesToScan)) {
            this.registerServiceBeans(resolvedPackagesToScan, registry);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("packagesToScan is empty , ServiceBean registry will be ignored!");
        }
    }

    private void registerServiceBeans(Set<String> packagesToScan, BeanDefinitionRegistry registry) {
        DubboClassPathBeanDefinitionScanner scanner = new DubboClassPathBeanDefinitionScanner(registry, this.environment, this.resourceLoader);
        BeanNameGenerator beanNameGenerator = this.resolveBeanNameGenerator(registry);
        scanner.setBeanNameGenerator(beanNameGenerator);
        serviceAnnotationTypes.forEach(annotationType -> scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType)));
        for (String packageToScan : packagesToScan) {
            scanner.scan(new String[]{packageToScan});
            Set<BeanDefinitionHolder> beanDefinitionHolders = this.findServiceBeanDefinitionHolders(scanner, packageToScan, registry, beanNameGenerator);
            if (!CollectionUtils.isEmpty(beanDefinitionHolders)) {
                for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitionHolders) {
                    this.registerServiceBean(beanDefinitionHolder, registry, scanner);
                }
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info(beanDefinitionHolders.size() + " annotated Dubbo's @Service Components { " + beanDefinitionHolders + " } were scanned under package[" + packageToScan + "]");
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("No Spring Bean annotating Dubbo's @Service was found under package[" + packageToScan + "]");
        }
    }

    private BeanNameGenerator resolveBeanNameGenerator(BeanDefinitionRegistry registry) {
        BeanNameGenerator beanNameGenerator = null;
        if (registry instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)SingletonBeanRegistry.class.cast(registry);
            beanNameGenerator = (BeanNameGenerator)singletonBeanRegistry.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        }
        if (beanNameGenerator == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("BeanNameGenerator bean can't be found in BeanFactory with name [org.springframework.context.annotation.internalConfigurationBeanNameGenerator]");
                this.logger.info("BeanNameGenerator will be a instance of " + AnnotationBeanNameGenerator.class.getName() + " , it maybe a potential problem on bean name generation.");
            }
            beanNameGenerator = new AnnotationBeanNameGenerator();
        }
        return beanNameGenerator;
    }

    private Set<BeanDefinitionHolder> findServiceBeanDefinitionHolders(ClassPathBeanDefinitionScanner scanner, String packageToScan, BeanDefinitionRegistry registry, BeanNameGenerator beanNameGenerator) {
        Set beanDefinitions = scanner.findCandidateComponents(packageToScan);
        LinkedHashSet<BeanDefinitionHolder> beanDefinitionHolders = new LinkedHashSet<BeanDefinitionHolder>(beanDefinitions.size());
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String beanName = beanNameGenerator.generateBeanName(beanDefinition, registry);
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
            beanDefinitionHolders.add(beanDefinitionHolder);
        }
        return beanDefinitionHolders;
    }

    private void registerServiceBean(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry registry, DubboClassPathBeanDefinitionScanner scanner) {
        String beanName;
        Class<?> beanClass = this.resolveClass(beanDefinitionHolder);
        Annotation service = this.findServiceAnnotation(beanClass);
        AnnotationAttributes serviceAnnotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)service, (boolean)false, (boolean)false);
        Class<?> interfaceClass = DubboAnnotationUtils.resolveServiceInterfaceClass(serviceAnnotationAttributes, beanClass);
        String annotatedServiceBeanName = beanDefinitionHolder.getBeanName();
        AbstractBeanDefinition serviceBeanDefinition = this.buildServiceBeanDefinition(service, serviceAnnotationAttributes, interfaceClass, annotatedServiceBeanName);
        Lazy lazyAnnotation = beanClass.getAnnotation(Lazy.class);
        if (lazyAnnotation != null) {
            serviceBeanDefinition.setLazyInit(lazyAnnotation.value());
        }
        if (scanner.checkCandidate(beanName = this.generateServiceBeanName(serviceAnnotationAttributes, interfaceClass), (BeanDefinition)serviceBeanDefinition)) {
            registry.registerBeanDefinition(beanName, (BeanDefinition)serviceBeanDefinition);
            if (!serviceBeanDefinition.getPropertyValues().contains("id")) {
                serviceBeanDefinition.getPropertyValues().addPropertyValue("id", (Object)beanName);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The BeanDefinition[" + serviceBeanDefinition + "] of ServiceBean has been registered with name : " + beanName);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("The Duplicated BeanDefinition[" + serviceBeanDefinition + "] of ServiceBean[ bean name : " + beanName + "] was be found , Did @DubboComponentScan scan to same package in many times?");
        }
    }

    private Annotation findServiceAnnotation(Class<?> beanClass) {
        return serviceAnnotationTypes.stream().map(annotationType -> AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanClass, (Class)annotationType)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String generateServiceBeanName(AnnotationAttributes serviceAnnotationAttributes, Class<?> interfaceClass) {
        ServiceBeanNameBuilder builder = ServiceBeanNameBuilder.create(interfaceClass, this.environment).group(serviceAnnotationAttributes.getString("group")).version(serviceAnnotationAttributes.getString("version"));
        return builder.build();
    }

    private Class<?> resolveClass(BeanDefinitionHolder beanDefinitionHolder) {
        BeanDefinition beanDefinition = beanDefinitionHolder.getBeanDefinition();
        return this.resolveClass(beanDefinition);
    }

    private Class<?> resolveClass(BeanDefinition beanDefinition) {
        String beanClassName = beanDefinition.getBeanClassName();
        return ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.classLoader);
    }

    private Set<String> resolvePackagesToScan(Set<String> packagesToScan) {
        LinkedHashSet<String> resolvedPackagesToScan = new LinkedHashSet<String>(packagesToScan.size());
        for (String packageToScan : packagesToScan) {
            if (!StringUtils.hasText((String)packageToScan)) continue;
            String resolvedPackageToScan = this.environment.resolvePlaceholders(packageToScan.trim());
            resolvedPackagesToScan.add(resolvedPackageToScan);
        }
        return resolvedPackagesToScan;
    }

    private AbstractBeanDefinition buildServiceBeanDefinition(Annotation serviceAnnotation, AnnotationAttributes serviceAnnotationAttributes, Class<?> interfaceClass, String annotatedServiceBeanName) {
        String[] protocolConfigBeanNames;
        ManagedList<RuntimeBeanReference> protocolRuntimeBeanReferences;
        String[] registryConfigBeanNames;
        ManagedList<RuntimeBeanReference> registryRuntimeBeanReferences;
        String moduleConfigBeanName;
        String applicationConfigBeanName;
        String monitorConfigBeanName;
        String providerConfigBeanName;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServiceBean.class);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        String[] ignoreAttributeNames = (String[])com.alibaba.spring.util.ObjectUtils.of((Object[])new String[]{"provider", "monitor", "application", "module", "registry", "protocol", "interface", "interfaceName", "parameters"});
        propertyValues.addPropertyValues((PropertyValues)new AnnotationPropertyValuesAdapter(serviceAnnotation, (PropertyResolver)this.environment, ignoreAttributeNames));
        this.addPropertyReference(builder, "ref", annotatedServiceBeanName);
        builder.addPropertyValue("interface", (Object)interfaceClass.getName());
        builder.addPropertyValue("parameters", this.convertParameters(serviceAnnotationAttributes.getStringArray("parameters")));
        List methodConfigs = this.convertMethodConfigs(serviceAnnotationAttributes.get((Object)"methods"));
        if (!methodConfigs.isEmpty()) {
            builder.addPropertyValue("methods", (Object)methodConfigs);
        }
        if (StringUtils.hasText((String)(providerConfigBeanName = serviceAnnotationAttributes.getString("provider")))) {
            this.addPropertyReference(builder, "provider", providerConfigBeanName);
        }
        if (StringUtils.hasText((String)(monitorConfigBeanName = serviceAnnotationAttributes.getString("monitor")))) {
            this.addPropertyReference(builder, "monitor", monitorConfigBeanName);
        }
        if (StringUtils.hasText((String)(applicationConfigBeanName = serviceAnnotationAttributes.getString("application")))) {
            this.addPropertyReference(builder, "application", applicationConfigBeanName);
        }
        if (StringUtils.hasText((String)(moduleConfigBeanName = serviceAnnotationAttributes.getString("module")))) {
            this.addPropertyReference(builder, "module", moduleConfigBeanName);
        }
        if (!(registryRuntimeBeanReferences = this.toRuntimeBeanReferences(registryConfigBeanNames = serviceAnnotationAttributes.getStringArray("registry"))).isEmpty()) {
            builder.addPropertyValue("registries", registryRuntimeBeanReferences);
        }
        if (!(protocolRuntimeBeanReferences = this.toRuntimeBeanReferences(protocolConfigBeanNames = serviceAnnotationAttributes.getStringArray("protocol"))).isEmpty()) {
            builder.addPropertyValue("protocols", protocolRuntimeBeanReferences);
        }
        return builder.getBeanDefinition();
    }

    private List convertMethodConfigs(Object methodsAnnotation) {
        if (methodsAnnotation == null) {
            return Collections.EMPTY_LIST;
        }
        return MethodConfig.constructMethodConfig((Method[])methodsAnnotation);
    }

    private ManagedList<RuntimeBeanReference> toRuntimeBeanReferences(String ... beanNames) {
        ManagedList runtimeBeanReferences = new ManagedList();
        if (!ObjectUtils.isEmpty((Object[])beanNames)) {
            for (String beanName : beanNames) {
                String resolvedBeanName = this.environment.resolvePlaceholders(beanName);
                runtimeBeanReferences.add((Object)new RuntimeBeanReference(resolvedBeanName));
            }
        }
        return runtimeBeanReferences;
    }

    private void addPropertyReference(BeanDefinitionBuilder builder, String propertyName, String beanName) {
        String resolvedBeanName = this.environment.resolvePlaceholders(beanName);
        builder.addPropertyReference(propertyName, resolvedBeanName);
    }

    private Map<String, String> convertParameters(String[] parameters) {
        if (ArrayUtils.isEmpty(parameters)) {
            return null;
        }
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("parameter attribute must be paired with key followed by value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; i += 2) {
            map.put(parameters[i], parameters[i + 1]);
        }
        return map;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

