/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.service;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.MQClientAPIImpl;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class RocketMQService {
    private static final Logger log = LoggerFactory.getLogger(RocketMQService.class);
    private String brokerAddr = "rocketmq-broker-0-master:10911";
    private int queueSize = 1;
    private String[] topics = new String[]{"hera_app_operate", "hera_app_modify_notice_open", "hera_app_ip_change", "hear_log_message_compensate", "mone_hera_staging_trace_etl_server", "mone_hera_staging_trace_etl_es", "mone_hera_jaeger_exporter", "hera_meta_data_staging"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTopic(String namesrvAddr) {
        DefaultMQPushConsumer consumer = null;
        MQClientInstance mqClientInstance = null;
        try {
            consumer = new DefaultMQPushConsumer("initGroup");
            consumer.setNamesrvAddr(namesrvAddr);
            ClientConfig clientConfig = consumer.cloneClientConfig();
            mqClientInstance = new MQClientInstance(clientConfig, 0, consumer.buildMQClientId());
            mqClientInstance.start();
            MQClientAPIImpl mqClientAPIImpl = mqClientInstance.getMQClientAPIImpl();
            for (String topic : this.topics) {
                this.createTopic(mqClientAPIImpl, topic);
            }
        }
        catch (Throwable t) {
            log.error("create rocketMQ topic error", t);
        }
        finally {
            if (consumer != null) {
                consumer.shutdown();
            }
            if (mqClientInstance != null) {
                mqClientInstance.shutdown();
            }
        }
    }

    private void createTopic(MQClientAPIImpl mqClientAPIImpl, String topicName) throws Exception {
        Set<String> topics = this.getTopics(mqClientAPIImpl);
        if (!topics.contains(topicName)) {
            TopicConfig topicConfig = new TopicConfig(topicName, this.queueSize, this.queueSize, 6);
            mqClientAPIImpl.createTopic(this.brokerAddr, "defaultTopicName", topicConfig, 2000L);
        } else {
            log.info("Exist topic, name is" + topicName + "unable to perform the add operation");
        }
    }

    private Set<String> getTopics(MQClientAPIImpl mqClientAPIImpl) {
        HashSet<String> topics = new HashSet<String>();
        long timeoutMillis = 2000L;
        try {
            TopicList topicList = mqClientAPIImpl.getTopicListFromNameServer(timeoutMillis);
            Set topicSet = topicList.getTopicList();
            topics.addAll(topicSet);
            TopicList systemTopicList = mqClientAPIImpl.getSystemTopicList(timeoutMillis);
            Set sysTopicSet = systemTopicList.getTopicList();
            topics.addAll(sysTopicSet);
            return topics;
        }
        catch (InterruptedException | MQClientException | RemotingException e) {
            throw new RuntimeException(e);
        }
    }
}

