/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;

public class HwmfPenStyle
implements Cloneable {
    private static final BitField SUBSECTION_DASH = BitFieldFactory.getInstance((int)7);
    private static final BitField SUBSECTION_ALTERNATE = BitFieldFactory.getInstance((int)8);
    private static final BitField SUBSECTION_ENDCAP = BitFieldFactory.getInstance((int)768);
    private static final BitField SUBSECTION_JOIN = BitFieldFactory.getInstance((int)12288);
    private int flag;

    public static HwmfPenStyle valueOf(int flag) {
        HwmfPenStyle ps = new HwmfPenStyle();
        ps.flag = flag;
        return ps;
    }

    public HwmfLineCap getLineCap() {
        return HwmfLineCap.valueOf(SUBSECTION_ENDCAP.getValue(this.flag));
    }

    public HwmfLineJoin getLineJoin() {
        return HwmfLineJoin.valueOf(SUBSECTION_JOIN.getValue(this.flag));
    }

    public HwmfLineDash getLineDash() {
        return HwmfLineDash.valueOf(SUBSECTION_DASH.getValue(this.flag));
    }

    public boolean isAlternateDash() {
        return SUBSECTION_ALTERNATE.isSet(this.flag);
    }

    public HwmfPenStyle clone() {
        try {
            return (HwmfPenStyle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static enum HwmfLineDash {
        SOLID(0, null),
        DASH(1, 10.0f, 8.0f),
        DOT(2, 2.0f, 4.0f),
        DASHDOT(3, 10.0f, 8.0f, 2.0f, 8.0f),
        DASHDOTDOT(4, 10.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f),
        NULL(5, null),
        INSIDEFRAME(6, null),
        USERSTYLE(7, null);

        public final int wmfFlag;
        public final float[] dashes;

        private HwmfLineDash(int wmfFlag, float ... dashes) {
            this.wmfFlag = wmfFlag;
            this.dashes = dashes;
        }

        static HwmfLineDash valueOf(int wmfFlag) {
            for (HwmfLineDash hs : HwmfLineDash.values()) {
                if (hs.wmfFlag != wmfFlag) continue;
                return hs;
            }
            return null;
        }
    }

    public static enum HwmfLineJoin {
        ROUND(0, 1),
        BEVEL(1, 2),
        MITER(2, 0);

        public final int wmfFlag;
        public final int awtFlag;

        private HwmfLineJoin(int wmfFlag, int awtFlag) {
            this.wmfFlag = wmfFlag;
            this.awtFlag = awtFlag;
        }

        static HwmfLineJoin valueOf(int wmfFlag) {
            for (HwmfLineJoin hs : HwmfLineJoin.values()) {
                if (hs.wmfFlag != wmfFlag) continue;
                return hs;
            }
            return null;
        }
    }

    public static enum HwmfLineCap {
        ROUND(0, 1),
        SQUARE(1, 2),
        FLAT(2, 0);

        public final int wmfFlag;
        public final int awtFlag;

        private HwmfLineCap(int wmfFlag, int awtFlag) {
            this.wmfFlag = wmfFlag;
            this.awtFlag = awtFlag;
        }

        static HwmfLineCap valueOf(int wmfFlag) {
            for (HwmfLineCap hs : HwmfLineCap.values()) {
                if (hs.wmfFlag != wmfFlag) continue;
                return hs;
            }
            return null;
        }
    }
}

