/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.prometheusClient;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.client.Client;
import org.apache.ozhera.prometheus.agent.enums.ScrapeJobStatusEnum;
import org.apache.ozhera.prometheus.agent.param.prometheus.PrometheusConfig;
import org.apache.ozhera.prometheus.agent.param.prometheus.Scrape_configs;
import org.apache.ozhera.prometheus.agent.param.scrapeConfig.ScrapeConfigDetail;
import org.apache.ozhera.prometheus.agent.service.prometheus.ScrapeJobService;
import org.apache.ozhera.prometheus.agent.util.CommitPoolUtil;
import org.apache.ozhera.prometheus.agent.util.FileUtil;
import org.apache.ozhera.prometheus.agent.util.Http;
import org.apache.ozhera.prometheus.agent.util.YamlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrometheusClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(PrometheusClient.class);
    @NacosValue(value="${job.prometheus.healthAddr}", autoRefreshed=true)
    private String healthAddr;
    @NacosValue(value="${job.prometheus.reloadAddr}", autoRefreshed=true)
    private String reloadAddr;
    @NacosValue(value="${job.prometheus.filePath}", autoRefreshed=true)
    private String filePath;
    private String backFilePath;
    @NacosValue(value="${job.prometheus.enabled}", autoRefreshed=true)
    private String enabled;
    private boolean firstInitSign = false;
    @Autowired
    ScrapeJobService scrapeJobService;
    public static final Gson gson = new Gson();
    private List<Scrape_configs> localConfigs = new ArrayList<Scrape_configs>();
    private ReentrantLock lock = new ReentrantLock();

    @PostConstruct
    public void init() {
        log.info("PrometheusLocalClient begin init!");
        this.backFilePath = this.filePath + ".bak";
        if (this.enabled.equals("true")) {
            log.info("PrometheusClient request health url :{}", (Object)this.healthAddr);
            String getHealthRes = Http.innerRequest((String)"", (String)this.healthAddr, (String)"GET");
            log.info("PrometheusClient request health res :{}", (Object)getHealthRes);
            if (getHealthRes.equals("200")) {
                this.scrapeJobService.setPendingScrapeConfig();
                this.GetLocalConfigs();
                this.CompareAndReload();
            } else {
                log.error("PrometheusClient request health fail !!!");
                System.exit(-1);
            }
        } else {
            log.info("PrometheusClient not init");
        }
    }

    @Override
    public void GetLocalConfigs() {
        CommitPoolUtil.PROMETHEUS_LOCAL_CONFIG_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            log.info("PrometheusClient start GetLocalConfigs");
            try {
                List allScrapeConfigList = this.scrapeJobService.getAllScrapeConfigList(ScrapeJobStatusEnum.PENDING.getDesc());
                this.localConfigs.clear();
                allScrapeConfigList.forEach(item -> {
                    ScrapeConfigDetail detail = (ScrapeConfigDetail)gson.fromJson(item.getBody(), ScrapeConfigDetail.class);
                    Scrape_configs sc = new Scrape_configs();
                    sc.setRelabel_configs(detail.getRelabel_configs());
                    sc.setMetric_relabel_configs(detail.getMetric_relabel_configs());
                    sc.setStatic_configs(detail.getStatic_configs());
                    sc.setJob_name(detail.getJob_name());
                    sc.setParams(detail.getParams());
                    sc.setMetrics_path(detail.getMetrics_path());
                    sc.setHonor_labels(detail.isHonor_labels());
                    sc.setHttp_sd_configs(detail.getHttp_sd_configs());
                    sc.setHttp_sd_configs(detail.getHttp_sd_configs());
                    this.localConfigs.add(sc);
                });
                log.info("PrometheusClient GetLocalConfigs done ,and jobNum :{}", (Object)this.localConfigs.size());
                this.firstInitSign = true;
            }
            catch (Exception e) {
                log.error("PrometheusClient GetLocalConfigs error :{}", (Object)e.getMessage());
            }
            finally {
                log.info("PrometheusClient end GetLocalConfigs cost: {}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void CompareAndReload() {
        CommitPoolUtil.PROMETHEUS_COMPARE_RELOAD_POOL.scheduleWithFixedDelay(() -> {
            Stopwatch sw = Stopwatch.createStarted();
            try {
                if (this.localConfigs.isEmpty()) {
                    log.info("prometheus scrapeJob no need to reload");
                    return;
                }
                if (!this.firstInitSign) {
                    log.info("PrometheusClient CompareAndReload waiting..");
                    return;
                }
                log.info("PrometheusClient start CompareAndReload");
                PrometheusConfig prometheusConfig = this.getPrometheusConfig(this.filePath);
                ArrayList<Scrape_configs> configList = this.mergeDbAndFileJobs(prometheusConfig);
                prometheusConfig.setScrape_configs(configList);
                log.info("PrometheusClient write final config:{}", (Object)gson.toJson((Object)prometheusConfig));
                this.writePrometheusConfig2Yaml(prometheusConfig);
                log.info("PrometheusClient request reload url :{}", (Object)this.reloadAddr);
                String getReloadRes = Http.innerRequest((String)"", (String)this.reloadAddr, (String)"POST");
                log.info("PrometheusClient request reload res :{}", (Object)getReloadRes);
                if (getReloadRes.equals("200")) {
                    log.info("PrometheusClient request reload success");
                    this.scrapeJobService.updateAllScrapeConfigListStatus(ScrapeJobStatusEnum.SUCCESS.getDesc(), configList);
                    this.deleteBackConfig();
                } else {
                    log.info("PrometheusClient request reload fail and begin rollback config");
                    boolean rollbackRes = this.restoreConfiguration(this.backFilePath, this.filePath);
                    log.info("PrometheusClient request reload fail and rollbackRes: {}", (Object)rollbackRes);
                }
            }
            catch (Exception e) {
                log.error("PrometheusClient CompareAndReload error :{}", (Object)e.getMessage());
            }
            finally {
                log.info("PrometheusClient end CompareAndReload cost: {}ms", (Object)sw.elapsed(TimeUnit.MILLISECONDS));
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Scrape_configs> mergeDbAndFileJobs(PrometheusConfig prometheusConfig) {
        this.lock.lock();
        try {
            if (prometheusConfig == null || prometheusConfig.getScrape_configs().isEmpty() || prometheusConfig.getGlobal() == null) {
                log.error("prometheusConfig null and return");
                ArrayList<Scrape_configs> arrayList = null;
                return arrayList;
            }
            List promScrapeConfig = prometheusConfig.getScrape_configs();
            HashMap<String, Scrape_configs> configMap = new HashMap<String, Scrape_configs>();
            promScrapeConfig.forEach(item -> configMap.put(item.getJob_name(), (Scrape_configs)item));
            this.localConfigs.forEach(item -> configMap.put(item.getJob_name(), (Scrape_configs)item));
            ArrayList<Scrape_configs> configList = new ArrayList<Scrape_configs>();
            configMap.forEach((k, v) -> configList.add((Scrape_configs)v));
            log.info("prometheusYMLJobNum: {},dbPEndingJobNum: {} after merge JobNum: {}", new Object[]{promScrapeConfig.size(), this.localConfigs.size(), configList.size()});
            ArrayList<Scrape_configs> arrayList = configList;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrometheusConfig getPrometheusConfig(String path) {
        this.lock.lock();
        try {
            log.info("PrometheusClient getPrometheusConfig path : {}", (Object)path);
            String content = FileUtil.LoadFile((String)path);
            PrometheusConfig prometheusConfig = (PrometheusConfig)YamlUtil.toObject((String)content, PrometheusConfig.class);
            log.info("PrometheusClient config : {}", (Object)prometheusConfig);
            PrometheusConfig prometheusConfig2 = prometheusConfig;
            return prometheusConfig2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writePrometheusConfig2Yaml(PrometheusConfig prometheusConfig) {
        String promYml = YamlUtil.toYaml((Object)prometheusConfig);
        log.info("checkNull promyml");
        if (!this.isFileExists(this.filePath)) {
            log.error("PrometheusClient PrometheusClient no files here path: {}", (Object)this.filePath);
            return;
        }
        this.backUpConfig();
        String writeRes = FileUtil.WriteFile((String)this.filePath, (String)promYml);
        if (StringUtils.isEmpty((CharSequence)writeRes)) {
            log.error("PrometheusClient WriteFile Error");
        }
        log.info("PrometheusClient WriteFile res : {}", (Object)writeRes);
    }

    private void backUpConfig() {
        String content;
        String writeRes;
        if (!this.isFileExists(this.filePath)) {
            log.error("PrometheusClient backUpConfig no files here path: {}", (Object)this.filePath);
            return;
        }
        if (!this.isFileExists(this.backFilePath)) {
            log.info("PrometheusClient backUpConfig backFile does not exist and begin create");
            FileUtil.GenerateFile((String)this.backFilePath);
        }
        if (StringUtils.isEmpty((CharSequence)(writeRes = FileUtil.WriteFile((String)this.backFilePath, (String)(content = FileUtil.LoadFile((String)this.filePath)))))) {
            log.error("PrometheusClient backUpConfig WriteFile Error");
        } else {
            log.info("PrometheusClient backUpConfig WriteFile success");
        }
    }

    private void deleteBackConfig() {
        if (!this.isFileExists(this.backFilePath)) {
            log.error("PrometheusClient deleteBackConfig no files here path: {}", (Object)this.backFilePath);
            return;
        }
        boolean deleteRes = FileUtil.DeleteFile((String)this.backFilePath);
        if (deleteRes) {
            log.info("PrometheusClient deleteBackConfig delete success");
        } else {
            log.error("PrometheusClient deleteBackConfig delete fail");
        }
    }

    private boolean isFileExists(String filePath) {
        return FileUtil.IsHaveFile((String)filePath);
    }

    private boolean restoreConfiguration(String oldFilePath, String newFilePath) {
        log.info("PrometheusClient restoreConfiguration oldPath: {}, newPath: {}", (Object)oldFilePath, (Object)newFilePath);
        boolean b = FileUtil.RenameFile((String)oldFilePath, (String)newFilePath);
        return b;
    }
}

