/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.util.Map;

public abstract class HttpResponseUtils {
    public static final String ContentTypeJson = "application/json; charset=utf-8";
    public static final String ContentTypeText = "text/plain; charset=utf-8";

    public static FullHttpResponse create(String content) {
        return HttpResponseUtils.create(content, HttpResponseStatus.OK, ContentTypeJson);
    }

    public static FullHttpResponse create(String content, Map<String, String> headers) {
        return HttpResponseUtils.create(content, HttpResponseStatus.OK, ContentTypeJson, headers);
    }

    public static FullHttpResponse create(FullHttpResponse res) {
        ByteBuf content = res.content();
        if (null == content) {
            res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        } else {
            res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        }
        return res;
    }

    public static FullHttpResponse create(FullHttpResponse res, String content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(res.protocolVersion(), res.status(), Unpooled.wrappedBuffer((byte[])content.getBytes(CharsetUtil.UTF_8)));
        if (content.length() == 0) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length());
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        return response;
    }

    public static String getContent(FullHttpResponse res) {
        byte[] data = new byte[res.content().readableBytes()];
        res.content().readBytes(data);
        res.content().readerIndex(0);
        return new String(data);
    }

    public static FullHttpResponse create(String content, String contentType) {
        return HttpResponseUtils.create(content, HttpResponseStatus.OK, contentType);
    }

    public static FullHttpResponse createDefaultSuccess() {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        return response;
    }

    public static FullHttpResponse create(String content, HttpResponseStatus code, String contentType) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, code, Unpooled.wrappedBuffer((byte[])content.getBytes(CharsetUtil.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        return response;
    }

    public static FullHttpResponse create(ByteBuf buf) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buf.readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)ContentTypeJson);
        return response;
    }

    public static FullHttpResponse create(String content, HttpResponseStatus code, String contentType, Map<String, String> headers) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, code, Unpooled.wrappedBuffer((byte[])content.getBytes(CharsetUtil.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        if (headers != null) {
            headers.entrySet().stream().forEach(arg_0 -> HttpResponseUtils.lambda$create$0((FullHttpResponse)response, arg_0));
        }
        return response;
    }

    private static /* synthetic */ void lambda$create$0(FullHttpResponse response, Map.Entry it) {
        response.headers().set((String)it.getKey(), it.getValue());
    }
}

