/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.config;

public class HttpServerConfig {
    private boolean ssl;
    private HttpVersion httpVersion;
    private boolean websocket;
    private int port;
    private boolean cookie;
    private boolean upload;
    private String uploadDir;
    private boolean useWs;
    public static int HTTP_POOL_SIZE = 500;
    public static int HTTP_POOL_QUEUE_SIZE = 1000;

    public HttpServerConfig(boolean ssl, boolean websocket, int port) {
        this.ssl = ssl;
        this.websocket = websocket;
        this.port = port;
    }

    public HttpServerConfig() {
    }

    private static HttpVersion $default$httpVersion() {
        return HttpVersion.http1;
    }

    private static boolean $default$cookie() {
        return true;
    }

    public static HttpServerConfigBuilder builder() {
        return new HttpServerConfigBuilder();
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public boolean isWebsocket() {
        return this.websocket;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isCookie() {
        return this.cookie;
    }

    public boolean isUpload() {
        return this.upload;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public boolean isUseWs() {
        return this.useWs;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setHttpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setWebsocket(boolean websocket) {
        this.websocket = websocket;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCookie(boolean cookie) {
        this.cookie = cookie;
    }

    public void setUpload(boolean upload) {
        this.upload = upload;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public void setUseWs(boolean useWs) {
        this.useWs = useWs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpServerConfig)) {
            return false;
        }
        HttpServerConfig other = (HttpServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSsl() != other.isSsl()) {
            return false;
        }
        if (this.isWebsocket() != other.isWebsocket()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isCookie() != other.isCookie()) {
            return false;
        }
        if (this.isUpload() != other.isUpload()) {
            return false;
        }
        if (this.isUseWs() != other.isUseWs()) {
            return false;
        }
        HttpVersion this$httpVersion = this.getHttpVersion();
        HttpVersion other$httpVersion = other.getHttpVersion();
        if (this$httpVersion == null ? other$httpVersion != null : !((Object)((Object)this$httpVersion)).equals((Object)other$httpVersion)) {
            return false;
        }
        String this$uploadDir = this.getUploadDir();
        String other$uploadDir = other.getUploadDir();
        return !(this$uploadDir == null ? other$uploadDir != null : !this$uploadDir.equals(other$uploadDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSsl() ? 79 : 97);
        result = result * 59 + (this.isWebsocket() ? 79 : 97);
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isCookie() ? 79 : 97);
        result = result * 59 + (this.isUpload() ? 79 : 97);
        result = result * 59 + (this.isUseWs() ? 79 : 97);
        HttpVersion $httpVersion = this.getHttpVersion();
        result = result * 59 + ($httpVersion == null ? 43 : ((Object)((Object)$httpVersion)).hashCode());
        String $uploadDir = this.getUploadDir();
        result = result * 59 + ($uploadDir == null ? 43 : $uploadDir.hashCode());
        return result;
    }

    public String toString() {
        return "HttpServerConfig(ssl=" + this.isSsl() + ", httpVersion=" + String.valueOf((Object)this.getHttpVersion()) + ", websocket=" + this.isWebsocket() + ", port=" + this.getPort() + ", cookie=" + this.isCookie() + ", upload=" + this.isUpload() + ", uploadDir=" + this.getUploadDir() + ", useWs=" + this.isUseWs() + ")";
    }

    public HttpServerConfig(boolean ssl, HttpVersion httpVersion, boolean websocket, int port, boolean cookie, boolean upload, String uploadDir, boolean useWs) {
        this.ssl = ssl;
        this.httpVersion = httpVersion;
        this.websocket = websocket;
        this.port = port;
        this.cookie = cookie;
        this.upload = upload;
        this.uploadDir = uploadDir;
        this.useWs = useWs;
    }

    public static enum HttpVersion {
        http1,
        http2;

    }

    public static class HttpServerConfigBuilder {
        private boolean ssl;
        private boolean httpVersion$set;
        private HttpVersion httpVersion$value;
        private boolean websocket;
        private int port;
        private boolean cookie$set;
        private boolean cookie$value;
        private boolean upload;
        private String uploadDir;
        private boolean useWs;

        HttpServerConfigBuilder() {
        }

        public HttpServerConfigBuilder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public HttpServerConfigBuilder httpVersion(HttpVersion httpVersion) {
            this.httpVersion$value = httpVersion;
            this.httpVersion$set = true;
            return this;
        }

        public HttpServerConfigBuilder websocket(boolean websocket) {
            this.websocket = websocket;
            return this;
        }

        public HttpServerConfigBuilder port(int port) {
            this.port = port;
            return this;
        }

        public HttpServerConfigBuilder cookie(boolean cookie) {
            this.cookie$value = cookie;
            this.cookie$set = true;
            return this;
        }

        public HttpServerConfigBuilder upload(boolean upload) {
            this.upload = upload;
            return this;
        }

        public HttpServerConfigBuilder uploadDir(String uploadDir) {
            this.uploadDir = uploadDir;
            return this;
        }

        public HttpServerConfigBuilder useWs(boolean useWs) {
            this.useWs = useWs;
            return this;
        }

        public HttpServerConfig build() {
            HttpVersion httpVersion$value = this.httpVersion$value;
            if (!this.httpVersion$set) {
                httpVersion$value = HttpServerConfig.$default$httpVersion();
            }
            boolean cookie$value = this.cookie$value;
            if (!this.cookie$set) {
                cookie$value = HttpServerConfig.$default$cookie();
            }
            return new HttpServerConfig(this.ssl, httpVersion$value, this.websocket, this.port, cookie$value, this.upload, this.uploadDir, this.useWs);
        }

        public String toString() {
            return "HttpServerConfig.HttpServerConfigBuilder(ssl=" + this.ssl + ", httpVersion$value=" + String.valueOf((Object)this.httpVersion$value) + ", websocket=" + this.websocket + ", port=" + this.port + ", cookie$value=" + this.cookie$value + ", upload=" + this.upload + ", uploadDir=" + this.uploadDir + ", useWs=" + this.useWs + ")";
        }
    }
}

