/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.xiaomi.youpin.feishu.FeiShu;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.prometheus.agent.service.FeishuService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FeishuServiceImpl
implements FeishuService {
    private static final Logger log = LoggerFactory.getLogger(FeishuServiceImpl.class);
    private FeiShu feiShu;
    private final Gson gson = new Gson();
    @NacosValue(value="${feishu.appid}", autoRefreshed=true)
    private String appId;
    @NacosValue(value="${feishu.appSecret}", autoRefreshed=true)
    private String appSecret;

    @PostConstruct
    private void init() {
        this.feiShu = new FeiShu(this.appId, this.appSecret);
    }

    @Override
    public void sendFeishu(String content, String[] receivers, String[] feishuGroups) {
        this.sendFeishu(content, receivers, feishuGroups, false);
    }

    @Override
    public void sendFeishu(String content, String[] receivers, String[] feishuGroups, boolean sendCard) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return;
        }
        log.info("sendFeishu content:{},receivers:{}", (Object)content, (Object)receivers);
        try {
            if (receivers != null) {
                for (String receiver : receivers) {
                    if (sendCard) {
                        this.feiShu.sendCardByEmail(receiver, content);
                        continue;
                    }
                    this.feiShu.sendMsgByEmail(receiver, content);
                }
            }
            if (feishuGroups != null) {
                for (String feishuGroup : feishuGroups) {
                    if (sendCard) {
                        this.feiShu.sendCardByChatId(feishuGroup, content);
                        continue;
                    }
                    this.feiShu.sendMsgByChatId(feishuGroup, content);
                }
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
    }

    @Override
    public String getUserIdByEmail(String email) {
        return this.feiShu.getUserIdByEmail(email);
    }
}

