/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.common;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeConverter {
    private static final String MICRO_SECOND = "us";
    private static final String MILLI_SECOND = "ms";
    private static final String SECOND = "s";
    private static final String LINE = "-";
    private static final int SCALE_UNIT = 1000;
    private static DateTimeFormatter TIME_BUCKET_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final DateTime DAY_ONE = TIME_BUCKET_FORMATTER.parseDateTime("20000101");
    private static int SUPER_DATASET_DAY_STEP = 1;

    public static long getMicro(String timeWithUnit) {
        if (StringUtils.isEmpty((CharSequence)timeWithUnit)) {
            return 0L;
        }
        if (TimeConverter.isNumeric(timeWithUnit)) {
            return Long.parseLong(timeWithUnit);
        }
        if (timeWithUnit.endsWith(MICRO_SECOND)) {
            String substring = timeWithUnit.substring(0, timeWithUnit.indexOf(MICRO_SECOND));
            return Long.parseLong(substring);
        }
        if (timeWithUnit.endsWith(MILLI_SECOND)) {
            String substring = timeWithUnit.substring(0, timeWithUnit.indexOf(MILLI_SECOND));
            return Long.parseLong(substring) * 1000L;
        }
        if (timeWithUnit.endsWith(SECOND)) {
            String substring = timeWithUnit.substring(0, timeWithUnit.indexOf(SECOND));
            return Long.parseLong(substring) * 1000L * 1000L;
        }
        return 0L;
    }

    public static boolean isNumeric(String cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String[] getIndexNamesByTimes(String indexName, long startTime, long endTime) {
        if (startTime == 0L || endTime == 0L) {
            return new String[]{indexName};
        }
        long endTimestampOfDay = Timestamp.valueOf(LocalDateTime.now().with(LocalTime.MAX)).getTime();
        if (endTime > endTimestampOfDay) {
            endTime = endTimestampOfDay;
        }
        DateTime startDateTime = new DateTime(startTime);
        DateTime endDateTime = new DateTime(endTime);
        ArrayList<DateTime> timeRanges = new ArrayList<DateTime>(16);
        for (int i = 0; i <= Days.daysBetween((ReadableInstant)startDateTime, (ReadableInstant)endDateTime).getDays(); ++i) {
            timeRanges.add(startDateTime.plusDays(i));
        }
        if (timeRanges.isEmpty()) {
            return new String[]{indexName};
        }
        return (String[])timeRanges.stream().map(item -> indexName + LINE + TimeConverter.formatCompressDateTime(item, SUPER_DATASET_DAY_STEP)).distinct().toArray(String[]::new);
    }

    private static String formatCompressDateTime(DateTime time, int dayStep) {
        return TimeConverter.formatDateTime(TimeConverter.compressDateTime(time, dayStep));
    }

    private static long compressDateTime(DateTime time, int dayStep) {
        if (dayStep > 1) {
            int days = Days.daysBetween((ReadableInstant)DAY_ONE, (ReadableInstant)time).getDays();
            int groupBucketOffset = days % dayStep;
            return Long.parseLong(time.minusDays(groupBucketOffset).toString(TIME_BUCKET_FORMATTER));
        }
        return Long.parseLong(time.toString(TIME_BUCKET_FORMATTER));
    }

    private static String formatDateTime(long dateTime) {
        String dateTimeStr = String.valueOf(dateTime);
        String year = dateTimeStr.substring(0, 4);
        String month = dateTimeStr.substring(4, 6);
        String day = dateTimeStr.substring(6, 8);
        return String.format("%s.%s.%s", year, month, day);
    }
}

