/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.rpc.task;

import com.xiaomi.data.push.rpc.RpcClient;
import com.xiaomi.data.push.rpc.netty.ResponseFuture;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.data.push.task.Task;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ozhera.log.api.model.meta.AppLogMeta;
import org.apache.ozhera.log.api.model.vo.PingReq;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(PingTask.class);
    private static final AtomicBoolean docker = new AtomicBoolean(false);
    public static final AtomicBoolean stop = new AtomicBoolean(false);
    private static final AtomicBoolean load = new AtomicBoolean(false);
    private static final AtomicReference<String> aip = new AtomicReference<String>("");
    private static final String IP = NetUtil.getLocalIp();

    public PingTask(RpcClient client) {
        super(() -> {
            if (stop.get()) {
                return;
            }
            try {
                PingReq ping = new PingReq();
                ping.setIp(IP);
                Object message = load.get() ? "ping:" + System.currentTimeMillis() : "load";
                ping.setMessage((String)message);
                RemotingCommand req = RemotingCommand.createRequestCommand((int)1001);
                req.setBody(Constant.GSON.toJson((Object)ping).getBytes());
                for (String service : (List)client.getServerList().get()) {
                    client.sendMessage(service, req, PingTask::handleResponse);
                }
                RpcClient.startLatch.countDown();
            }
            catch (Exception ex) {
                log.error("ping error:{}", (Object)ex.getMessage());
            }
        }, 10L);
    }

    private static void handleResponse(ResponseFuture responseFuture) {
        if (responseFuture.getResponseCommand() == null) {
            return;
        }
        String body = new String(responseFuture.getResponseCommand().getBody());
        if (!load.get()) {
            AppLogMeta alm = (AppLogMeta)Constant.GSON.fromJson(body, AppLogMeta.class);
            load.set(true);
            log.info("load config finish: {}", (Object)alm);
        }
        log.info("ping res: {}", (Object)body);
    }
}

