/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.extension;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.agent.common.HashUtil;
import org.apache.ozhera.log.agent.common.trace.TraceUtil;
import org.apache.ozhera.log.agent.export.MsgExporter;
import org.apache.ozhera.log.api.model.msg.LineMessage;
import org.apache.ozhera.tspandata.TSpanData;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmqExporter
implements MsgExporter {
    private static final Logger log = LoggerFactory.getLogger(RmqExporter.class);
    private DefaultMQProducer mqProducer;
    private String rmqTopic;
    private Integer batchSize;
    private Gson gson = new Gson();
    private List<MessageQueue> messageQueueList;

    public RmqExporter(DefaultMQProducer mqProducer) {
        this.mqProducer = mqProducer;
    }

    @Override
    public void export(LineMessage message) {
        this.export(Lists.newArrayList((Object[])new LineMessage[]{message}));
    }

    @Override
    public void export(List<LineMessage> messageList) {
        if (messageList.isEmpty()) {
            return;
        }
        this.messageQueueList = this.fetchMessageQueue(this.rmqTopic);
        ArrayList<Message> logMessages = new ArrayList<Message>();
        HashMap<MessageQueue, List<Message>> messageQueueListMap = new HashMap<MessageQueue, List<Message>>();
        for (LineMessage lineMessage : messageList) {
            if (OPENTELEMETRY_TYPE.equals(lineMessage.getProperties(LineMessage.KEY_MESSAGE_TYPE))) {
                this.processOpenTelemetryMessage(lineMessage, messageQueueListMap);
                continue;
            }
            this.processLogMessage(lineMessage, logMessages);
        }
        this.sendMessagesToQueues(messageQueueListMap);
        this.sendMessagesToProducer(logMessages);
    }

    private void processOpenTelemetryMessage(LineMessage lineMessage, Map<MessageQueue, List<Message>> messageQueueListMap) {
        byte[] bytes = TraceUtil.toBytes(lineMessage.getMsgBody());
        if (bytes != null) {
            TSpanData tSpanData = TraceUtil.toTSpanData(lineMessage.getMsgBody());
            String appName = tSpanData.getExtra().getServiceName();
            Message message = new Message();
            message.setBody(bytes);
            message.setTopic(this.rmqTopic);
            MessageQueue messageQueue = this.calculateMessageQueue(appName);
            messageQueueListMap.putIfAbsent(messageQueue, new ArrayList());
            messageQueueListMap.get(messageQueue).add(message);
        }
    }

    private void processLogMessage(LineMessage lineMessage, List<Message> logMessages) {
        Message message = new Message();
        message.setTags(lineMessage.getProperties(LineMessage.KEY_MQ_TOPIC_TAG));
        message.setBody(this.gson.toJson((Object)lineMessage).getBytes(StandardCharsets.UTF_8));
        message.setTopic(this.rmqTopic);
        logMessages.add(message);
    }

    private MessageQueue calculateMessageQueue(String appName) {
        Integer partitionNumber = 2;
        appName = String.format("p%s%s", ThreadLocalRandom.current().nextInt(partitionNumber), appName);
        return this.messageQueueList.get(HashUtil.consistentHash(appName, this.messageQueueList.size()));
    }

    private void sendMessagesToQueues(Map<MessageQueue, List<Message>> messageQueueListMap) {
        try {
            for (Map.Entry<MessageQueue, List<Message>> queueListEntry : messageQueueListMap.entrySet()) {
                List<Message> messages = queueListEntry.getValue();
                if (!CollectionUtils.isNotEmpty(messages)) continue;
                this.mqProducer.send(messages, queueListEntry.getKey());
            }
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            log.error("OPENTELEMETRY log rocketMQ export error", e);
        }
    }

    private void sendMessagesToProducer(List<Message> logMessages) {
        try {
            if (CollectionUtils.isNotEmpty(logMessages)) {
                this.mqProducer.send(logMessages);
            }
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            log.error("normal rocketMQ export error", e);
        }
    }

    public String getRmqTopic() {
        return this.rmqTopic;
    }

    public void setRmqTopic(String rmqTopic) {
        this.messageQueueList = this.fetchMessageQueue(rmqTopic);
        this.rmqTopic = rmqTopic;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int batchExportSize() {
        if (null == this.batchSize || this.batchSize < 0) {
            return 200;
        }
        return this.batchSize;
    }

    @Override
    public void close() {
    }

    public List<MessageQueue> fetchMessageQueue(String topicName) {
        try {
            return this.mqProducer.fetchPublishMessageQueues(topicName);
        }
        catch (MQClientException e) {
            log.error("fetch queue task error : ", (Throwable)e);
            return new ArrayList<MessageQueue>();
        }
    }
}

