/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.processor;

import java.util.ArrayList;
import java.util.List;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionFilter;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.ObjectInfo;
import org.nutz.mvc.Processor;
import org.nutz.mvc.View;
import org.nutz.mvc.impl.processor.AbstractProcessor;

public class ActionFiltersProcessor
extends AbstractProcessor {
    protected List<ActionFilter> filters = new ArrayList<ActionFilter>();
    protected Processor proxyProcessor;
    protected Processor lastProcessor;

    @Override
    public void init(NutConfig config, ActionInfo ai) throws Throwable {
        ObjectInfo<? extends ActionFilter>[] filterInfos = ai.getFilterInfos();
        if (null != filterInfos) {
            for (int i = 0; i < filterInfos.length; ++i) {
                ActionFilter filter = ActionFiltersProcessor.evalObj(config, filterInfos[i]);
                this.filters.add(filter);
                if (!(filter instanceof Processor)) continue;
                Processor processor = (Processor)((Object)filter);
                if (this.proxyProcessor == null) {
                    this.proxyProcessor = processor;
                    this.lastProcessor = processor;
                    continue;
                }
                processor.setNext(this.proxyProcessor);
                this.proxyProcessor = processor;
            }
        }
    }

    @Override
    public void process(ActionContext ac) throws Throwable {
        for (ActionFilter filter : this.filters) {
            View view = filter.match(ac);
            if (null == view) continue;
            ac.setMethodReturn(view);
            this.renderView(ac);
            return;
        }
        if (this.proxyProcessor == null) {
            this.doNext(ac);
        } else {
            if (this.lastProcessor != null) {
                this.lastProcessor.setNext(this.next);
            }
            this.proxyProcessor.process(ac);
        }
    }
}

