/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor.injector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ObjectNaviNode {
    private static final char separator = '.';
    private static final char LIST_SEPARATOR = ':';
    private static final int TYPE_NONE = 0;
    private static final int TYPE_LIST = 1;
    private String name;
    private String[] value;
    private boolean leaf = true;
    private Map<String, ObjectNaviNode> child = new HashMap<String, ObjectNaviNode>();
    private int type = 0;

    public void put(String path, String[] value) {
        StringBuilder sb = new StringBuilder();
        char[] chars = path.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '(': 
                case '[': {
                    ++i;
                    StringBuilder sb2 = new StringBuilder();
                    boolean isNumber = true;
                    while (i < chars.length) {
                        char c2 = chars[i];
                        switch (c2) {
                            case ')': 
                            case ']': {
                                if ((c != '[' || c2 != ']') && (c != '(' || c2 != ')')) break;
                                if (isNumber && c != '(') {
                                    sb.append(':').append((CharSequence)sb2);
                                    continue block6;
                                }
                                sb.append('.').append((CharSequence)sb2);
                                continue block6;
                            }
                        }
                        isNumber = isNumber && Character.isDigit(c2);
                        sb2.append(c2);
                        ++i;
                    }
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        path = sb.toString();
        this.putPath(path, value);
    }

    private void putPath(String path, String[] value) {
        this.init(path);
        String subPath = this.fetchSubPath(path);
        if ("".equals(subPath) || path.equals(subPath)) {
            this.value = value;
            return;
        }
        this.leaf = false;
        this.addChild(subPath, value);
    }

    private void addChild(String path, String[] value) {
        String subname = this.fetchName(path);
        ObjectNaviNode onn = this.child.get(subname);
        if (onn == null) {
            onn = new ObjectNaviNode();
        }
        onn.putPath(path, value);
        this.child.put(subname, onn);
    }

    private void init(String path) {
        String key = ObjectNaviNode.fetchNode(path);
        if (ObjectNaviNode.isList(key)) {
            this.type = 1;
            this.name = key.substring(0, key.indexOf(58));
            return;
        }
        this.name = key;
    }

    private String fetchSubPath(String path) {
        if (ObjectNaviNode.isList(ObjectNaviNode.fetchNode(path))) {
            return path.substring(path.indexOf(58) + 1);
        }
        return path.substring(path.indexOf(46) + 1);
    }

    private static String fetchNode(String path) {
        if (path.indexOf(46) <= 0) {
            return path;
        }
        return path.substring(0, path.indexOf(46));
    }

    private String fetchName(String path) {
        String key = ObjectNaviNode.fetchNode(path);
        if (ObjectNaviNode.isList(key)) {
            return key.substring(0, key.indexOf(58));
        }
        return key;
    }

    public Object get() {
        if (this.isLeaf()) {
            return this.value == null ? null : (this.value.length == 1 ? this.value[0] : this.value);
        }
        if (this.type == 1) {
            ArrayList<Object> list = new ArrayList<Object>();
            ArrayList<Integer> keys = new ArrayList<Integer>();
            ArrayList<String> keys2 = new ArrayList<String>();
            for (String key : this.child.keySet()) {
                try {
                    keys.add(Integer.parseInt(key));
                }
                catch (NumberFormatException e) {
                    keys2.add(key);
                }
            }
            Collections.sort(keys);
            for (Integer index : keys) {
                list.add(this.child.get(index.toString()).get());
            }
            for (String key2 : keys2) {
                list.add(this.child.get(key2).get());
            }
            return list;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String o : this.child.keySet()) {
            map.put(o, this.child.get(o).get());
        }
        return map;
    }

    private static boolean isList(String key) {
        return key.indexOf(58) > 0;
    }

    public String getName() {
        return this.name;
    }

    public String[] getValue() {
        return this.value;
    }

    public boolean isLeaf() {
        return this.leaf;
    }
}

