/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class ZipUtils {
    private static final Log log = Logs.get();

    public static List<String> names(String filePath, String endSuffix) {
        log.info("filePath:" + filePath + ",endSuffix:" + endSuffix);
        ArrayList<String> result = new ArrayList<String>();
        try {
            ZipEntry ze;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            Charset charset = Charset.forName("utf8");
            ZipInputStream zin = new ZipInputStream((InputStream)in, charset);
            while ((ze = zin.getNextEntry()) != null) {
                if (!ze.getName().endsWith(endSuffix)) continue;
                result.add(ze.getName());
            }
            zin.closeEntry();
            ((InputStream)in).close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            log.error(ex.getMessage(), ex);
        }
        return result;
    }
}

