/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.nutz.ioc.IocContext;
import org.nutz.ioc.ObjectProxy;

public class ComboContext
implements IocContext {
    private IocContext[] contexts;

    public ComboContext(IocContext ... contexts) {
        ArrayList<IocContext> tmp = new ArrayList<IocContext>(contexts.length);
        for (IocContext iocContext : contexts) {
            if (tmp.contains(iocContext)) continue;
            if (iocContext instanceof ComboContext) {
                ComboContext comboContext = (ComboContext)iocContext;
                for (IocContext iocContext2 : comboContext.contexts) {
                    if (tmp.contains(iocContext2)) continue;
                    tmp.add(iocContext2);
                }
                continue;
            }
            tmp.add(iocContext);
        }
        this.contexts = tmp.toArray(new IocContext[tmp.size()]);
    }

    @Override
    public ObjectProxy fetch(String key) {
        for (IocContext c : this.contexts) {
            ObjectProxy re = c.fetch(key);
            if (null == re) continue;
            return re;
        }
        return null;
    }

    @Override
    public boolean save(String scope, String name, ObjectProxy obj) {
        boolean re = false;
        for (IocContext c : this.contexts) {
            re |= c.save(scope, name, obj);
        }
        return re;
    }

    @Override
    public boolean remove(String scope, String name) {
        boolean re = false;
        for (IocContext c : this.contexts) {
            re |= c.remove(scope, name);
        }
        return re;
    }

    @Override
    public void clear() {
        for (IocContext c : this.contexts) {
            c.clear();
        }
    }

    @Override
    public void depose() {
        for (IocContext c : this.contexts) {
            c.depose();
        }
    }

    public IocContext[] getContexts() {
        return this.contexts;
    }

    @Override
    public Set<String> names() {
        HashSet<String> list = new HashSet<String>();
        for (IocContext c : this.contexts) {
            list.addAll(c.names());
        }
        return list;
    }
}

