/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;

public class SimpleClob
implements Clob,
Serializable {
    private static final long serialVersionUID = -5465130240603178708L;
    private File file;

    public SimpleClob() {
    }

    public SimpleClob(File f) {
        this.file = f;
    }

    @Override
    public long length() throws SQLException {
        return this.file.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("pos<1");
        }
        String str = Files.read(this.file);
        if (--pos >= (long)length) {
            throw new IllegalArgumentException("pos=" + pos);
        }
        if (pos + (long)length >= this.length()) {
            return str.substring((int)pos);
        }
        return str.substring((int)pos, (int)(pos + (long)length - 1L));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return Streams.fileInr(this.file);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return Streams.buff(Streams.fileIn(this.file));
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw Lang.noImplement();
    }

    @Override
    public void truncate(long len) throws SQLException {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
            raf.setLength(len);
            raf.close();
        }
        catch (FileNotFoundException e) {
            throw Lang.wrapThrow(e);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    @Override
    public void free() throws SQLException {
        Files.deleteFile(this.file);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw Lang.noImplement();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Streams.writeAndClose((OutputStream)out, new FileInputStream(this.file));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.file = Jdbcs.getFilePool().createFile(".clob");
        Files.write(this.file, (Object)in);
    }
}

