/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.List;
import org.nutz.castor.Castors;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.impl.entity.field.NutMappingField;
import org.nutz.dao.impl.sql.SqlFormat;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.SqlContext;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.util.Daos;
import org.nutz.dao.util.blob.SimpleBlob;
import org.nutz.dao.util.blob.SimpleClob;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public abstract class NutStatement
implements DaoStatement {
    private static final long serialVersionUID = 1L;
    private transient Entity<?> entity;
    private SqlContext context = new SqlContext();
    private SqlType sqlType;
    protected transient JdbcExpert expert;

    @Override
    public boolean isSelect() {
        return SqlType.SELECT == this.sqlType;
    }

    @Override
    public boolean isUpdate() {
        return SqlType.UPDATE == this.sqlType;
    }

    @Override
    public boolean isDelete() {
        return SqlType.DELETE == this.sqlType;
    }

    @Override
    public boolean isInsert() {
        return SqlType.INSERT == this.sqlType;
    }

    @Override
    public boolean isCreate() {
        return SqlType.CREATE == this.sqlType;
    }

    @Override
    public boolean isDrop() {
        return SqlType.DROP == this.sqlType;
    }

    @Override
    public boolean isRun() {
        return SqlType.RUN == this.sqlType;
    }

    @Override
    public boolean isAlter() {
        return SqlType.ALTER == this.sqlType;
    }

    @Override
    public boolean isExec() {
        return SqlType.EXEC == this.sqlType;
    }

    @Override
    public boolean isCall() {
        return SqlType.CALL == this.sqlType;
    }

    @Override
    public boolean isOther() {
        return SqlType.OTHER == this.sqlType;
    }

    @Override
    public Entity<?> getEntity() {
        return this.entity;
    }

    @Override
    public DaoStatement setEntity(Entity<?> entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public SqlContext getContext() {
        return this.context;
    }

    public void setContext(SqlContext context) {
        this.context = context;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public DaoStatement setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
        return this;
    }

    @Override
    public Object getResult() {
        return this.context.getResult();
    }

    @Override
    public <T> List<T> getList(Class<T> classOfT) {
        Object re = this.getResult();
        if (re == null) {
            return null;
        }
        if (re.getClass().isArray()) {
            return Lang.array2list(re, classOfT);
        }
        return (List)re;
    }

    @Override
    public <T> T getObject(Class<T> classOfT) {
        return Castors.me().castTo(this.getResult(), classOfT);
    }

    @Override
    public int getInt() {
        return this.getNumber().intValue();
    }

    @Override
    public int getInt(int defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.intValue();
    }

    @Override
    public long getLong() {
        return this.getNumber().longValue();
    }

    @Override
    public long getLong(long defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.longValue();
    }

    @Override
    public double getDouble() {
        return this.getNumber().doubleValue();
    }

    @Override
    public double getDouble(double defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.doubleValue();
    }

    @Override
    public float getFloat() {
        return this.getNumber().floatValue();
    }

    @Override
    public float getFloat(float defaultValue) {
        Number re = this.getNumber();
        if (re == null) {
            return defaultValue;
        }
        return re.floatValue();
    }

    @Override
    public Number getNumber() {
        return this.getObject(Number.class);
    }

    @Override
    public String getString() {
        return this.getObject(String.class);
    }

    @Override
    public boolean getBoolean() {
        return this.getObject(Boolean.class);
    }

    @Override
    public int getUpdateCount() {
        return this.context.getUpdateCount();
    }

    @Override
    public String forPrint() {
        String sql = this.toPreparedStatement();
        StringBuilder sb = new StringBuilder(sql);
        Object[][] mtrx = this.getParamMatrix();
        SqlFormat format = Daos.getSqlFormat();
        if (null != mtrx && mtrx.length > 0 && mtrx[0].length > 0) {
            if (format.isPrintParam()) {
                int i;
                int[] maxes = new int[mtrx[0].length];
                String[][] sss = new String[mtrx.length][mtrx[0].length];
                for (int row = 0; row < mtrx.length; ++row) {
                    for (int col = 0; col < mtrx[0].length; ++col) {
                        String s = this.param2String(mtrx[row][col]);
                        maxes[col] = Math.max(maxes[col], s.length());
                        if (format.getParamLengthLimit() > 0 && maxes[col] > format.getParamLengthLimit()) {
                            maxes[col] = format.getParamLengthLimit();
                        }
                        sss[row][col] = s;
                    }
                }
                sb.append("\n    |");
                for (i = 0; i < mtrx[0].length; ++i) {
                    sb.append(' ');
                    sb.append(Strings.alignRight("" + (i + 1), maxes[i], ' '));
                    sb.append(" |");
                }
                sb.append("\n    |");
                for (i = 0; i < mtrx[0].length; ++i) {
                    sb.append('-');
                    sb.append(Strings.dup('-', maxes[i]));
                    sb.append("-|");
                }
                int maxRow = mtrx.length > format.getParamRowLimit() ? format.getParamRowLimit() : mtrx.length;
                for (int row = 0; row < maxRow; ++row) {
                    sb.append("\n    |");
                    for (int col = 0; col < mtrx[0].length; ++col) {
                        sb.append(' ');
                        sb.append(sss[row][col].length() > maxes[col] ? Strings.brief(sss[row][col], maxes[col] - 5) : Strings.alignLeft(sss[row][col], maxes[col], ' '));
                        sb.append(" |");
                    }
                }
                if (maxRow != mtrx.length) {
                    sb.append("\n -- Only display first " + maxRow + " lines , don't show the remaining record(count=" + mtrx.length + ")");
                }
            }
            if (format.isPrintExample()) {
                sb.append("\n  For example:> \"");
                sb.append(this.toExampleStatement(mtrx, sql));
                sb.append('\"');
            }
        }
        return sb.toString();
    }

    protected String toExampleStatement(Object[][] mtrx, String sql) {
        return this.toStatement(mtrx, sql);
    }

    protected String toStatement(Object[][] mtrx, String sql) {
        int i;
        StringBuilder sb = new StringBuilder();
        String[] ss = sql.split("[?]");
        if (mtrx.length > 0) {
            for (i = 0; i < mtrx[0].length; ++i) {
                sb.append(ss[i]);
                Object tmp = mtrx[0][i];
                if (tmp == null) {
                    sb.append("NULL");
                    continue;
                }
                if (tmp instanceof Number || tmp instanceof Boolean) {
                    sb.append(tmp.toString());
                    continue;
                }
                sb.append(Sqls.formatFieldValue(this.param2String(tmp)));
            }
        }
        while (i < ss.length) {
            sb.append(ss[i]);
            ++i;
        }
        return sb.toString();
    }

    protected String param2String(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            if (blob instanceof SimpleBlob) {
                try {
                    return "*Blob(len=" + blob.length() + ")";
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "*Blob(hascode=" + blob.hashCode() + ")";
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            if (clob instanceof SimpleClob) {
                try {
                    return "*Clob(len=" + clob.length() + ")";
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return "*Clob(" + clob.hashCode() + ")";
        }
        if (obj instanceof byte[] || obj instanceof char[]) {
            return "*" + (obj instanceof byte[] ? "byte" : "char") + "[len=" + Array.getLength(obj) + "]";
        }
        if (obj instanceof InputStream) {
            try {
                obj = "*InputStream[len=" + ((InputStream)obj).available() + "]";
            }
            catch (IOException iOException) {}
        } else if (obj instanceof Reader) {
            obj = "*Reader@" + obj.hashCode();
        }
        return Castors.me().castToString(obj);
    }

    @Override
    public void forceExecQuery() {
        this.sqlType = SqlType.SELECT;
    }

    @Override
    public boolean isForceExecQuery() {
        return this.isSelect();
    }

    @Override
    public String toString() {
        return this.toStatement(this.getParamMatrix(), this.toPreparedStatement());
    }

    @Override
    public void setExpert(JdbcExpert expert) {
        this.expert = expert;
    }

    protected ValueAdaptor getAdapterBy(Object value) {
        if (value == null) {
            return Jdbcs.Adaptor.asNull;
        }
        if (this.expert == null) {
            return Jdbcs.getAdaptorBy(value);
        }
        NutMappingField mf = new NutMappingField(this.entity);
        mf.setType(value.getClass());
        Jdbcs.guessEntityFieldColumnType(mf);
        return this.expert.getAdaptor(mf);
    }

    @Override
    public DaoStatement setQueryTimeout(int timeout) {
        this.getContext().setQueryTimeout(timeout);
        return this;
    }
}

