/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao;

import org.nutz.castor.Castors;
import org.nutz.dao.impl.sql.NutSql;
import org.nutz.dao.impl.sql.ValueEscaper;
import org.nutz.dao.impl.sql.callback.FetchBlobCallback;
import org.nutz.dao.impl.sql.callback.FetchBooleanCallback;
import org.nutz.dao.impl.sql.callback.FetchDoubleCallback;
import org.nutz.dao.impl.sql.callback.FetchEntityCallback;
import org.nutz.dao.impl.sql.callback.FetchFloatCallback;
import org.nutz.dao.impl.sql.callback.FetchIntegerCallback;
import org.nutz.dao.impl.sql.callback.FetchLongCallback;
import org.nutz.dao.impl.sql.callback.FetchMapCallback;
import org.nutz.dao.impl.sql.callback.FetchRecordCallback;
import org.nutz.dao.impl.sql.callback.FetchStringCallback;
import org.nutz.dao.impl.sql.callback.FetchTimestampCallback;
import org.nutz.dao.impl.sql.callback.QueryBooleanCallback;
import org.nutz.dao.impl.sql.callback.QueryEntityCallback;
import org.nutz.dao.impl.sql.callback.QueryIntCallback;
import org.nutz.dao.impl.sql.callback.QueryLongCallback;
import org.nutz.dao.impl.sql.callback.QueryMapCallback;
import org.nutz.dao.impl.sql.callback.QueryRecordCallback;
import org.nutz.dao.impl.sql.callback.QueryStringArrayCallback;
import org.nutz.dao.impl.sql.callback.QueryStringCallback;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.lang.Mirror;
import org.nutz.lang.born.Borning;

public abstract class Sqls {
    private static final ValueEscaper ES_FLD_VAL = new ValueEscaper();
    private static final ValueEscaper ES_SQL_FLD = new ValueEscaper();
    private static final ValueEscaper ES_CND_VAL = new ValueEscaper();
    private static Borning<? extends Sql> sqlBorning;
    public static CallbackFactory callback;

    public static <T extends Sql> void setSqlBorning(Class<T> type) {
        sqlBorning = Mirror.me(type).getBorningByArgTypes(String.class);
    }

    public static Sql create(String sql) {
        return sqlBorning.born(sql);
    }

    public static Sql createf(String fmt, Object ... args) {
        return Sqls.create(String.format(fmt, args));
    }

    public static Sql fetchEntity(String sql) {
        return Sqls.create(sql).setCallback(callback.entity());
    }

    public static Sql fetchRecord(String sql) {
        return Sqls.create(sql).setCallback(callback.record());
    }

    public static Sql fetchInt(String sql) {
        return Sqls.create(sql).setCallback(callback.integer());
    }

    public static Sql fetchLong(String sql) {
        return Sqls.create(sql).setCallback(callback.longValue());
    }

    public static Sql fetchFloat(String sql) {
        return Sqls.create(sql).setCallback(callback.floatValue());
    }

    public static Sql fetchDouble(String sql) {
        return Sqls.create(sql).setCallback(callback.doubleValue());
    }

    public static Sql fetchTimestamp(String sql) {
        return Sqls.create(sql).setCallback(callback.timestamp());
    }

    public static Sql fetchString(String sql) {
        return Sqls.create(sql).setCallback(callback.str());
    }

    public static Sql queryString(String sql) {
        return Sqls.create(sql).setCallback(callback.strs());
    }

    public static Sql queryEntity(String sql) {
        return Sqls.create(sql).setCallback(callback.entities());
    }

    public static Sql queryRecord(String sql) {
        return Sqls.create(sql).setCallback(callback.records());
    }

    public static CharSequence formatFieldValue(Object v) {
        if (null == v) {
            return "NULL";
        }
        if (Sqls.isNotNeedQuote(v.getClass())) {
            return Sqls.escapeFieldValue(v.toString());
        }
        return new StringBuilder("'").append(Sqls.escapeFieldValue(Castors.me().castToString(v))).append('\'');
    }

    public static CharSequence formatSqlFieldValue(Object v) {
        if (null == v) {
            return "NULL";
        }
        if (Sqls.isNotNeedQuote(v.getClass())) {
            return Sqls.escapeSqlFieldValue(v.toString());
        }
        return new StringBuilder("'").append(Sqls.escapeSqlFieldValue(v.toString())).append('\'');
    }

    public static CharSequence escapeFieldValue(CharSequence s) {
        if (null == s) {
            return null;
        }
        return ES_FLD_VAL.escape(s);
    }

    public static CharSequence escapeSqlFieldValue(CharSequence s) {
        if (null == s) {
            return null;
        }
        return ES_SQL_FLD.escape(s);
    }

    public static CharSequence escapteConditionValue(CharSequence s) {
        if (null == s) {
            return null;
        }
        return ES_CND_VAL.escape(s);
    }

    public static boolean isNotNeedQuote(Class<?> type) {
        Mirror<Class<?>> me = Mirror.me(type);
        return me.isBoolean() || me.isPrimitiveNumber();
    }

    static {
        ES_FLD_VAL.add('\'', "''").add('\\', "\\\\").ready();
        ES_SQL_FLD.add('\'', "''").add('\\', "\\\\").add('$', "$$").add('@', "@@").ready();
        ES_CND_VAL.add('\'', "''").add('\\', "\\\\").add('_', "\\_").add('%', "\\%").ready();
        Sqls.setSqlBorning(NutSql.class);
        callback = new CallbackFactory();
    }

    public static class CallbackFactory {
        public SqlCallback entity() {
            return this.entity(null);
        }

        public SqlCallback entity(String prefix) {
            return new FetchEntityCallback(prefix);
        }

        public SqlCallback record() {
            return new FetchRecordCallback();
        }

        public SqlCallback integer() {
            return new FetchIntegerCallback();
        }

        public SqlCallback longValue() {
            return new FetchLongCallback();
        }

        public SqlCallback floatValue() {
            return new FetchFloatCallback();
        }

        public SqlCallback doubleValue() {
            return new FetchDoubleCallback();
        }

        public SqlCallback timestamp() {
            return new FetchTimestampCallback();
        }

        public SqlCallback str() {
            return new FetchStringCallback();
        }

        public SqlCallback ints() {
            return new QueryIntCallback();
        }

        public SqlCallback longs() {
            return new QueryLongCallback();
        }

        public SqlCallback strs() {
            return new QueryStringArrayCallback();
        }

        public SqlCallback strList() {
            return new QueryStringCallback();
        }

        public SqlCallback entities() {
            return this.entities(null);
        }

        public SqlCallback entities(String prefix) {
            return new QueryEntityCallback(prefix);
        }

        public SqlCallback records() {
            return new QueryRecordCallback();
        }

        public SqlCallback bool() {
            return new FetchBooleanCallback();
        }

        public SqlCallback bools() {
            return new QueryBooleanCallback();
        }

        public SqlCallback map() {
            return FetchMapCallback.me;
        }

        public SqlCallback maps() {
            return QueryMapCallback.me;
        }

        public SqlCallback blob() {
            return new FetchBlobCallback();
        }
    }
}

