/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.server.service;

import cn.hutool.core.util.NumberUtil;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.dubbo.anno.Service;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.model.vo.AgentLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.TailLogProcessDTO;
import org.apache.ozhera.log.api.model.vo.UpdateLogProcessCmd;
import org.apache.ozhera.log.api.service.LogProcessCollector;
import org.apache.ozhera.log.common.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(interfaceClass=LogProcessCollector.class, group="$dubbo.group", timeout=10000)
public class DefaultLogProcessCollector
implements LogProcessCollector {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogProcessCollector.class);
    private final Map<String, List<UpdateLogProcessCmd.CollectDetail>> tailProgressMap = new ConcurrentHashMap<String, List<UpdateLogProcessCmd.CollectDetail>>(256);
    private static final Integer MAX_INTERRUPT_TIME = 10;
    private static final Integer MAX_STATIC_INTERRUPT_TIME_HOUR = 4;
    private static final String PROCESS_SEPARATOR = "%";

    public void collectLogProcess(UpdateLogProcessCmd cmd) {
        log.debug("[LogProcess.updateLogProcess] cmd:{} ", (Object)cmd);
        if (cmd == null || StringUtils.isEmpty((CharSequence)cmd.getIp())) {
            return;
        }
        this.tailProgressMap.put(cmd.getIp(), cmd.getCollectList());
    }

    public List<TailLogProcessDTO> getTailLogProcess(Long tailId, String tailName, String targetIp) {
        if (null == tailId || StringUtils.isBlank((CharSequence)tailName)) {
            return new ArrayList<TailLogProcessDTO>();
        }
        List<Object> dtoList = this.tailProgressMap.values().stream().flatMap(Collection::stream).filter(collectDetail -> Objects.equals(tailId.toString(), collectDetail.getTailId())).flatMap(collectDetail -> collectDetail.getFileProgressDetails().stream()).map(fileProgressDetail -> TailLogProcessDTO.builder().tailName(tailName).collectTime(fileProgressDetail.getCollectTime()).collectPercentage(fileProgressDetail.getCollectPercentage()).ip(fileProgressDetail.getConfigIp()).path(fileProgressDetail.getPattern()).fileRowNumber(fileProgressDetail.getFileRowNumber()).build()).filter(processDTO -> StringUtils.isNotBlank((CharSequence)processDTO.getIp())).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)targetIp)) {
            dtoList = dtoList.stream().filter(processDTO -> Objects.equals(targetIp, processDTO.getIp())).collect(Collectors.toList());
        }
        List<Object> perOneIpProgressList = Lists.newArrayList();
        try {
            perOneIpProgressList = this.getTailLogProcessDTOS(dtoList, perOneIpProgressList);
            perOneIpProgressList = this.filterExpireTimePath(perOneIpProgressList);
        }
        catch (Exception e) {
            log.error("getTailLogProcess error,dtoList:{}", (Object)Constant.GSON.toJson(dtoList), (Object)e);
        }
        return perOneIpProgressList;
    }

    public List<AgentLogProcessDTO> getAgentLogProcess(String ip) {
        ArrayList dtoList = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)ip) || this.tailProgressMap.isEmpty()) {
            return dtoList;
        }
        List collect = this.tailProgressMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        collect.stream().forEach(collectDetail -> {
            try {
                String appName = collectDetail.getAppName();
                if (CollectionUtils.isNotEmpty((Collection)collectDetail.getFileProgressDetails())) {
                    dtoList.addAll(collectDetail.getFileProgressDetails().stream().filter(processDTO -> StringUtils.isNotBlank((CharSequence)processDTO.getConfigIp())).filter(processDTO -> Objects.equals(ip, processDTO.getConfigIp())).map(fileProgressDetail -> {
                        AgentLogProcessDTO agentLogProcessDTO = new AgentLogProcessDTO();
                        agentLogProcessDTO.setPath(fileProgressDetail.getPattern());
                        agentLogProcessDTO.setFileRowNumber(fileProgressDetail.getFileRowNumber());
                        agentLogProcessDTO.setPointer(fileProgressDetail.getPointer());
                        agentLogProcessDTO.setFileMaxPointer(fileProgressDetail.getFileMaxPointer());
                        agentLogProcessDTO.setAppName(appName);
                        agentLogProcessDTO.setCollectPercentage(fileProgressDetail.getCollectPercentage());
                        agentLogProcessDTO.setCollectTime(fileProgressDetail.getCollectTime());
                        return agentLogProcessDTO;
                    }).collect(Collectors.toList()));
                }
            }
            catch (Exception e) {
                log.error("getAgentLogProcess error,ip:{},CollectDetail:{}", new Object[]{ip, Constant.GSON.toJson(collectDetail), e});
            }
        });
        return dtoList;
    }

    public List<UpdateLogProcessCmd.CollectDetail> getColProcessImperfect(Double progressRation) {
        List<Object> resultList = Lists.newArrayList();
        if (null == progressRation || this.tailProgressMap.isEmpty()) {
            return resultList;
        }
        resultList = this.tailProgressMap.values().stream().flatMap(Collection::stream).map(collectDetail -> {
            List fileProgressDetails = collectDetail.getFileProgressDetails();
            if (CollectionUtils.isNotEmpty((Collection)fileProgressDetails)) {
                List progressDetails = fileProgressDetails.stream().filter(fileProgressDetail -> this.lessThenRation(fileProgressDetail.getCollectPercentage(), progressRation)).filter(tailLogProcessDTO -> null != tailLogProcessDTO.getCollectTime() && Instant.now().toEpochMilli() - tailLogProcessDTO.getCollectTime() < TimeUnit.HOURS.toMillis(MAX_STATIC_INTERRUPT_TIME_HOUR.intValue())).collect(Collectors.toList());
                collectDetail.setFileProgressDetails(progressDetails);
            }
            return collectDetail;
        }).filter(collectDetail -> CollectionUtils.isNotEmpty((Collection)collectDetail.getFileProgressDetails())).collect(Collectors.toList());
        return resultList;
    }

    public List<UpdateLogProcessCmd.FileProgressDetail> getFileProcessDetailByTail(Long tailId) {
        ArrayList<UpdateLogProcessCmd.FileProgressDetail> resultList = new ArrayList<UpdateLogProcessCmd.FileProgressDetail>();
        if (tailId == null) {
            return resultList;
        }
        try {
            for (List<UpdateLogProcessCmd.CollectDetail> details : this.tailProgressMap.values()) {
                for (UpdateLogProcessCmd.CollectDetail detail : details) {
                    if (!String.valueOf(tailId).equals(detail.getTailId())) continue;
                    resultList.addAll(detail.getFileProgressDetails());
                }
            }
        }
        catch (Throwable t) {
            log.error("getFileProcessDetailByTail error : ", t);
        }
        return resultList;
    }

    public List<UpdateLogProcessCmd.CollectDetail> getAllCollectDetail(String ip) {
        return this.tailProgressMap.get(ip);
    }

    private boolean lessThenRation(String source, Double targetNum) {
        try {
            double sourceOrigin = Double.parseDouble(StringUtils.substringBefore((String)source, (String)PROCESS_SEPARATOR));
            double sourceNum = NumberUtil.div((double)sourceOrigin, (double)100.0);
            return Double.valueOf(sourceNum).compareTo(targetNum) < 0;
        }
        catch (Exception e) {
            log.error("lessThenRation error,source:{},target:{}", new Object[]{source, targetNum, e});
            return true;
        }
    }

    private List<TailLogProcessDTO> getTailLogProcessDTOS(List<TailLogProcessDTO> dtoList, List<TailLogProcessDTO> perOneIpProgressList) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            Map<String, List<TailLogProcessDTO>> collect = dtoList.stream().collect(Collectors.groupingBy(processDTO -> String.format("%s-%s", processDTO.getIp(), processDTO.getPath())));
            perOneIpProgressList = collect.keySet().stream().map(s -> {
                List tailLogProcessDTOS = (List)collect.get(s);
                return tailLogProcessDTOS.stream().sorted(Comparator.comparing(TailLogProcessDTO::getCollectTime).reversed()).findFirst().get();
            }).collect(Collectors.toList());
            return perOneIpProgressList;
        }
        return Lists.newArrayList();
    }

    private List<TailLogProcessDTO> filterExpireTimePath(List<TailLogProcessDTO> tailLogProcessDTOS) {
        return tailLogProcessDTOS.stream().filter(processDTO -> Objects.nonNull(processDTO.getCollectTime()) && Instant.now().toEpochMilli() - processDTO.getCollectTime() < TimeUnit.MINUTES.toMillis(MAX_INTERRUPT_TIME.intValue())).collect(Collectors.toList());
    }
}

