/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.model.prometheus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.service.model.prometheus.EsIndexDataType;

public class MetricDetailQuery
implements Serializable {
    private static final String domain = "domain";
    private static final Long tesla_projectId = 1L;
    private static final String host_ = "host";
    private static final String type_ = "type";
    private static final String errorType_ = "errorType";
    private static final String serviceName_ = "serviceName";
    private static final String dataSource_ = "dataSource";
    private static final String url_ = "url";
    private static final String clientProjectId_ = "clientProjectId";
    private static final String clientProjectName_ = "clientProjectName";
    private static final String clientEnv_ = "clientEnv";
    private static final String clientIp_ = "clientIp";
    private String serverEnv;
    private String serverZone;
    private String area;
    private Long projectId;
    private String projectName;
    private Integer appSource;
    private String type;
    private String errorType;
    private String serverIp;
    private String methodName;
    private String serviceName;
    private String clientProjectId;
    private String clientProjectName;
    private String clientEnv;
    private String clientIp;
    private String sql;
    private String dataSource;
    private String sqlMethod;
    private Long startTime;
    private Long endTime;
    private Integer page;
    private Integer pageSize;

    public Map<String, String> convertPrometheusParam() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("application", this.projectId + "_" + this.projectName.replaceAll("-", "_"));
        map.put("serverIp", this.serverIp);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.methodName})) {
            map.put("methodName", this.methodName);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.serviceName})) {
            map.put(serviceName_, this.serviceName);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.sqlMethod})) {
            map.put("sqlMethod", this.sqlMethod);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.sql})) {
            map.put("sql", this.sql);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.dataSource})) {
            map.put(dataSource_, this.dataSource);
        }
        return map;
    }

    public String convertDorisSql() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select * from hera_error_slow_trace where 1=1 ");
        sqlBuilder.append(" and serviceName='").append(this.projectId).append("_").append(this.projectName.replaceAll("-", "_")).append("' ");
        sqlBuilder.append(" and host='").append(this.serverIp).append("' ");
        sqlBuilder.append(" and type='").append(this.type).append("' ");
        sqlBuilder.append(" and errorType='").append(this.errorType).append("' ");
        if (EsIndexDataType.http.name().equals(this.type) || EsIndexDataType.http_client.name().equals(this.type) || EsIndexDataType.mq_consumer.name().equals(this.type) || EsIndexDataType.mq_producer.name().equals(this.type) || EsIndexDataType.redis.name().equals(this.type)) {
            sqlBuilder.append(" and url='").append(this.methodName).append("' ");
        }
        if (EsIndexDataType.dubbo_consumer.name().equals(this.type) || EsIndexDataType.dubbo_provider.name().equals(this.type) || EsIndexDataType.grpc_client.name().equals(this.type) || EsIndexDataType.grpc_server.name().equals(this.type) || EsIndexDataType.thrift_client.name().equals(this.type) || EsIndexDataType.thrift_server.name().equals(this.type) || EsIndexDataType.apus_client.name().equals(this.type) || EsIndexDataType.apus_server.name().equals(this.type)) {
            sqlBuilder.append(" and url='").append(this.serviceName + "/" + this.methodName).append("' ");
        }
        if (EsIndexDataType.mysql.name().equals(this.type) || EsIndexDataType.oracle.name().equals(this.type) || EsIndexDataType.hbase.name().equals(this.type) || EsIndexDataType.elasticsearch.name().equals(this.type)) {
            sqlBuilder.append(" and dataSource='").append(this.dataSource).append("' ");
            sqlBuilder.append(" and url like '%").append(this.sql).append("%' ");
        }
        if (this.startTime != null) {
            sqlBuilder.append(" and timestamp>=").append(this.startTime).append(" ");
        }
        if (this.endTime != null) {
            sqlBuilder.append(" and timestamp<=").append(this.endTime).append(" ");
        }
        sqlBuilder.append(" order by timestamp desc ");
        if (this.page == null || this.page < 1) {
            this.page = 1;
        }
        if (this.pageSize == null || this.pageSize < 1) {
            this.pageSize = 20;
        }
        sqlBuilder.append(" limit ").append((this.page - 1) * this.pageSize).append(",").append(this.pageSize);
        return sqlBuilder.toString();
    }

    public String convertDorisSqlCount() {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select count(1) as total from hera_error_slow_trace where 1=1 ");
        sqlBuilder.append(" and serviceName='").append(this.projectId).append("_").append(this.projectName.replaceAll("-", "_")).append("' ");
        sqlBuilder.append(" and host='").append(this.serverIp).append("' ");
        sqlBuilder.append(" and type='").append(this.type).append("' ");
        sqlBuilder.append(" and errorType='").append(this.errorType).append("' ");
        if (EsIndexDataType.http.name().equals(this.type) || EsIndexDataType.http_client.name().equals(this.type) || EsIndexDataType.mq_consumer.name().equals(this.type) || EsIndexDataType.mq_producer.name().equals(this.type) || EsIndexDataType.redis.name().equals(this.type)) {
            sqlBuilder.append(" and url='").append(this.methodName).append("' ");
        }
        if (EsIndexDataType.dubbo_consumer.name().equals(this.type) || EsIndexDataType.dubbo_provider.name().equals(this.type) || EsIndexDataType.grpc_client.name().equals(this.type) || EsIndexDataType.grpc_server.name().equals(this.type) || EsIndexDataType.thrift_client.name().equals(this.type) || EsIndexDataType.thrift_server.name().equals(this.type) || EsIndexDataType.apus_client.name().equals(this.type) || EsIndexDataType.apus_server.name().equals(this.type)) {
            sqlBuilder.append(" and url='").append(this.serviceName + "/" + this.methodName).append("' ");
        }
        if (EsIndexDataType.mysql.name().equals(this.type) || EsIndexDataType.oracle.name().equals(this.type) || EsIndexDataType.hbase.name().equals(this.type) || EsIndexDataType.elasticsearch.name().equals(this.type)) {
            sqlBuilder.append(" and dataSource='").append(this.dataSource).append("' ");
            sqlBuilder.append(" and url like '%").append(this.sql).append("%' ");
        }
        if (this.startTime != null) {
            sqlBuilder.append(" and timestamp>=").append(this.startTime).append(" ");
        }
        if (this.endTime != null) {
            sqlBuilder.append(" and timestamp<=").append(this.endTime).append(" ");
        }
        if (this.page == null || this.page < 1) {
            this.page = 1;
        }
        if (this.pageSize == null || this.pageSize < 1) {
            this.pageSize = 20;
        }
        sqlBuilder.append(" limit ").append((this.page - 1) * this.pageSize).append(",").append(this.pageSize);
        return sqlBuilder.toString();
    }

    public Map<String, String> convertEsParam(String exceptionTraceDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(domain, exceptionTraceDomain);
        map.put(serviceName_, this.projectId + "_" + this.projectName.replaceAll("-", "_"));
        map.put(host_, this.serverIp);
        map.put(type_, this.type);
        map.put(errorType_, this.errorType);
        if (EsIndexDataType.http.name().equals(this.type) || EsIndexDataType.http_client.name().equals(this.type) || EsIndexDataType.mq_consumer.name().equals(this.type) || EsIndexDataType.mq_producer.name().equals(this.type) || EsIndexDataType.redis.name().equals(this.type)) {
            map.put(url_, this.methodName);
        }
        if (EsIndexDataType.dubbo_consumer.name().equals(this.type) || EsIndexDataType.dubbo_provider.name().equals(this.type) || EsIndexDataType.grpc_client.name().equals(this.type) || EsIndexDataType.grpc_server.name().equals(this.type) || EsIndexDataType.thrift_client.name().equals(this.type) || EsIndexDataType.thrift_server.name().equals(this.type) || EsIndexDataType.apus_client.name().equals(this.type) || EsIndexDataType.apus_server.name().equals(this.type)) {
            map.put(url_, this.serviceName + "/" + this.methodName);
        }
        if (EsIndexDataType.dubbo_sla.name().equals(this.type)) {
            map.put(url_, this.serviceName + "/" + this.methodName);
            map.put(clientProjectId_, this.clientProjectId);
            map.put(clientProjectName_, this.clientProjectName);
            map.put(clientEnv_, this.clientEnv);
            map.put(clientIp_, this.clientIp);
        }
        if (EsIndexDataType.mysql.name().equals(this.type) || EsIndexDataType.oracle.name().equals(this.type) || EsIndexDataType.hbase.name().equals(this.type) || EsIndexDataType.elasticsearch.name().equals(this.type)) {
            map.put(dataSource_, this.dataSource);
            map.put(url_, this.sql);
        }
        return map;
    }

    public String getServerEnv() {
        return this.serverEnv;
    }

    public String getServerZone() {
        return this.serverZone;
    }

    public String getArea() {
        return this.area;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Integer getAppSource() {
        return this.appSource;
    }

    public String getType() {
        return this.type;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClientProjectId() {
        return this.clientProjectId;
    }

    public String getClientProjectName() {
        return this.clientProjectName;
    }

    public String getClientEnv() {
        return this.clientEnv;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getSql() {
        return this.sql;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSqlMethod() {
        return this.sqlMethod;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setServerEnv(String serverEnv) {
        this.serverEnv = serverEnv;
    }

    public void setServerZone(String serverZone) {
        this.serverZone = serverZone;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setClientProjectId(String clientProjectId) {
        this.clientProjectId = clientProjectId;
    }

    public void setClientProjectName(String clientProjectName) {
        this.clientProjectName = clientProjectName;
    }

    public void setClientEnv(String clientEnv) {
        this.clientEnv = clientEnv;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setSqlMethod(String sqlMethod) {
        this.sqlMethod = sqlMethod;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricDetailQuery)) {
            return false;
        }
        MetricDetailQuery other = (MetricDetailQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$projectId = this.getProjectId();
        Long other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        Integer this$appSource = this.getAppSource();
        Integer other$appSource = other.getAppSource();
        if (this$appSource == null ? other$appSource != null : !((Object)this$appSource).equals(other$appSource)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        String this$serverEnv = this.getServerEnv();
        String other$serverEnv = other.getServerEnv();
        if (this$serverEnv == null ? other$serverEnv != null : !this$serverEnv.equals(other$serverEnv)) {
            return false;
        }
        String this$serverZone = this.getServerZone();
        String other$serverZone = other.getServerZone();
        if (this$serverZone == null ? other$serverZone != null : !this$serverZone.equals(other$serverZone)) {
            return false;
        }
        String this$area = this.getArea();
        String other$area = other.getArea();
        if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$errorType = this.getErrorType();
        String other$errorType = other.getErrorType();
        if (this$errorType == null ? other$errorType != null : !this$errorType.equals(other$errorType)) {
            return false;
        }
        String this$serverIp = this.getServerIp();
        String other$serverIp = other.getServerIp();
        if (this$serverIp == null ? other$serverIp != null : !this$serverIp.equals(other$serverIp)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$clientProjectId = this.getClientProjectId();
        String other$clientProjectId = other.getClientProjectId();
        if (this$clientProjectId == null ? other$clientProjectId != null : !this$clientProjectId.equals(other$clientProjectId)) {
            return false;
        }
        String this$clientProjectName = this.getClientProjectName();
        String other$clientProjectName = other.getClientProjectName();
        if (this$clientProjectName == null ? other$clientProjectName != null : !this$clientProjectName.equals(other$clientProjectName)) {
            return false;
        }
        String this$clientEnv = this.getClientEnv();
        String other$clientEnv = other.getClientEnv();
        if (this$clientEnv == null ? other$clientEnv != null : !this$clientEnv.equals(other$clientEnv)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$dataSource = this.getDataSource();
        String other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        String this$sqlMethod = this.getSqlMethod();
        String other$sqlMethod = other.getSqlMethod();
        return !(this$sqlMethod == null ? other$sqlMethod != null : !this$sqlMethod.equals(other$sqlMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetricDetailQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        Integer $appSource = this.getAppSource();
        result = result * 59 + ($appSource == null ? 43 : ((Object)$appSource).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        String $serverEnv = this.getServerEnv();
        result = result * 59 + ($serverEnv == null ? 43 : $serverEnv.hashCode());
        String $serverZone = this.getServerZone();
        result = result * 59 + ($serverZone == null ? 43 : $serverZone.hashCode());
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $errorType = this.getErrorType();
        result = result * 59 + ($errorType == null ? 43 : $errorType.hashCode());
        String $serverIp = this.getServerIp();
        result = result * 59 + ($serverIp == null ? 43 : $serverIp.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $clientProjectId = this.getClientProjectId();
        result = result * 59 + ($clientProjectId == null ? 43 : $clientProjectId.hashCode());
        String $clientProjectName = this.getClientProjectName();
        result = result * 59 + ($clientProjectName == null ? 43 : $clientProjectName.hashCode());
        String $clientEnv = this.getClientEnv();
        result = result * 59 + ($clientEnv == null ? 43 : $clientEnv.hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        String $sqlMethod = this.getSqlMethod();
        result = result * 59 + ($sqlMethod == null ? 43 : $sqlMethod.hashCode());
        return result;
    }

    public String toString() {
        return "MetricDetailQuery(serverEnv=" + this.getServerEnv() + ", serverZone=" + this.getServerZone() + ", area=" + this.getArea() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", appSource=" + this.getAppSource() + ", type=" + this.getType() + ", errorType=" + this.getErrorType() + ", serverIp=" + this.getServerIp() + ", methodName=" + this.getMethodName() + ", serviceName=" + this.getServiceName() + ", clientProjectId=" + this.getClientProjectId() + ", clientProjectName=" + this.getClientProjectName() + ", clientEnv=" + this.getClientEnv() + ", clientIp=" + this.getClientIp() + ", sql=" + this.getSql() + ", dataSource=" + this.getDataSource() + ", sqlMethod=" + this.getSqlMethod() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ")";
    }
}

