/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.google.gson.Gson;
import org.apache.dubbo.config.annotation.Service;
import org.apache.ozhera.monitor.service.AppGrafanaMappingService;
import org.apache.ozhera.monitor.service.GrafanaApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(registry={"registryConfig"}, interfaceClass=GrafanaApiService.class, retries=0, group="${dubbo.group}")
public class GrafanaApiServiceImpl
implements GrafanaApiService {
    private static final Logger log = LoggerFactory.getLogger(GrafanaApiServiceImpl.class);
    @Autowired
    AppGrafanaMappingService appGrafanaMappingService;

    public String getUrlByAppName(String appName) {
        log.info("Dubbo.GrafanaServiceImpl.getUrlByAppName param appName : {}", (Object)appName);
        String result = new Gson().toJson((Object)this.appGrafanaMappingService.getGrafanaUrlByAppName(appName));
        log.info("Dubbo.GrafanaServiceImpl.getUrlByAppName param appName : {} ,return result : {}", (Object)appName, (Object)result);
        return result;
    }

    public String createGrafanaUrlByAppName(String appName, String area) {
        log.info("Dubbo.GrafanaServiceImpl.createGrafanaUrlByAppName param appName : {}", (Object)appName);
        String result = this.appGrafanaMappingService.createGrafanaUrlByAppName(appName, area);
        log.info("Dubbo.GrafanaServiceImpl.createGrafanaUrlByAppName param appName : {} ,return result : {}", (Object)appName, (Object)result);
        return result;
    }
}

