/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.List;
import javax.annotation.Resource;
import org.apache.ozhera.monitor.dao.mapper.AppGrafanaBlackListMapper;
import org.apache.ozhera.monitor.dao.model.AppGrafanaBlackList;
import org.apache.ozhera.monitor.dao.model.AppGrafanaBlackListExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class GrafanaBlackListDao {
    private static final Logger log = LoggerFactory.getLogger(GrafanaBlackListDao.class);
    @Resource
    private AppGrafanaBlackListMapper appGrafanaBlackListMapper;

    public Integer createBlackList(String serverName) {
        AppGrafanaBlackList appGrafanaBlackList = new AppGrafanaBlackList();
        try {
            appGrafanaBlackList.setServerName(serverName);
            int insertRes = this.appGrafanaBlackListMapper.insert(appGrafanaBlackList);
            log.info("GrafanaBlackListDao.createBlackList res:{}", (Object)insertRes);
            return insertRes;
        }
        catch (Exception e) {
            log.error("GrafanaBlackListDao.createBlackList error :{}", (Object)e.getMessage());
            return -1;
        }
    }

    public AppGrafanaBlackList getBlackList(String serverName) {
        AppGrafanaBlackListExample aje = new AppGrafanaBlackListExample();
        aje.createCriteria().andServerNameEqualTo(serverName);
        List<AppGrafanaBlackList> appGrafanaBlackLists = this.appGrafanaBlackListMapper.selectByExample(aje);
        if (appGrafanaBlackLists.size() >= 1) {
            log.info("GrafanaBlackListDao.getBlackList res:{}", (Object)appGrafanaBlackLists.get(0));
            return appGrafanaBlackLists.get(0);
        }
        return null;
    }

    public List<AppGrafanaBlackList> getBlackListByServerName(String serverName) {
        AppGrafanaBlackListExample aje = new AppGrafanaBlackListExample();
        aje.createCriteria().andServerNameEqualTo(serverName);
        List<AppGrafanaBlackList> appGrafanaBlackLists = this.appGrafanaBlackListMapper.selectByExample(aje);
        return appGrafanaBlackLists;
    }

    public Integer delBlackList(Integer id) {
        try {
            int res = this.appGrafanaBlackListMapper.deleteByPrimaryKey(id);
            log.info("GrafanaBlackListDao.delBlackList res:{}", (Object)res);
            return res;
        }
        catch (Exception e) {
            log.error("GrafanaBlackListDao.delBlackList error :{}", (Object)e.getMessage());
            return -1;
        }
    }

    public Integer delBlackListByServerName(String serverName) {
        try {
            AppGrafanaBlackListExample aje = new AppGrafanaBlackListExample();
            aje.createCriteria().andServerNameEqualTo(serverName);
            int res = this.appGrafanaBlackListMapper.deleteByExample(aje);
            log.info("GrafanaBlackListDao.delBlackList res:{}", (Object)res);
            return res;
        }
        catch (Exception e) {
            log.error("GrafanaBlackListDao.delBlackList error :{}", (Object)e.getMessage());
            return -1;
        }
    }

    public long getTotalBlackList() {
        AppGrafanaBlackListExample aje = new AppGrafanaBlackListExample();
        long total = this.appGrafanaBlackListMapper.countByExample(aje);
        log.info("GrafanaBlackListDao.getTotalBlackList total:{}", (Object)total);
        return total;
    }

    public List<AppGrafanaBlackList> getAllBlackList(Integer pageNo, Integer pageSize) {
        AppGrafanaBlackListExample aje = new AppGrafanaBlackListExample();
        aje.setOrderByClause("id desc");
        aje.setLimit(pageSize);
        aje.setOffset((pageNo - 1) * pageSize);
        try {
            List<AppGrafanaBlackList> list = this.appGrafanaBlackListMapper.selectByExample(aje);
            if (list == null) {
                log.warn("GrafanaBlackListDao.getAllBlackList failed to search");
            }
            return list;
        }
        catch (Exception e) {
            log.error("GrafanaBlackListDao.getAllBlackList failed to search err: {}", (Object)e.toString());
            return null;
        }
    }
}

