/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.mapper.AppServiceMarketMapper;
import org.apache.ozhera.monitor.dao.model.AppServiceMarket;
import org.apache.ozhera.monitor.dao.model.AppServiceMarketExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppServiceMarketDao {
    private static final Logger log = LoggerFactory.getLogger(AppServiceMarketDao.class);
    @Autowired
    private AppServiceMarketMapper appServiceMarketMapper;

    public int insertServiceMarket(AppServiceMarket appServiceMarket) {
        appServiceMarket.setCreateTime(new Date());
        appServiceMarket.setUpdateTime(new Date());
        try {
            int result = this.appServiceMarketMapper.insert(appServiceMarket);
            if (result < 0) {
                log.warn("[AppServiceMarketDao.insert] failed to insert AppServiceMarketDao: {}", (Object)appServiceMarket.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppServiceMarketDao.insert] failed to insert AppServiceMarketDao: {}, err: {}", (Object)appServiceMarket.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public int deleteServiceMarket(Integer id) {
        try {
            int result = this.appServiceMarketMapper.deleteByPrimaryKey(id);
            if (result < 0) {
                log.warn("[AppServiceMarketDao.update] failed to delete AppServiceMarketDaoId: {}", (Object)id);
                return 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppServiceMarketDao.update] failed to delete AppServiceMarketDaoId : {} err: {}", (Object)id, (Object)e);
            return 0;
        }
    }

    public int updateServiceMarket(AppServiceMarket appServiceMarket) {
        System.out.println("1233333333333333333333");
        appServiceMarket.setUpdateTime(new Date());
        try {
            System.out.println(appServiceMarket.getMarketName());
            int result = this.appServiceMarketMapper.updateByPrimaryKey(appServiceMarket);
            if (result < 0) {
                log.warn("[AppServiceMarketDao.update] failed to update AppServiceMarketDao: {}", (Object)appServiceMarket.toString());
                return 0;
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppServiceMarketDao.update] failed to update AppServiceMarketDao : {} err: {}", (Object)appServiceMarket.toString(), (Object)e);
            return 0;
        }
    }

    public AppServiceMarket SearchAppServiceMarket(Integer id) {
        try {
            AppServiceMarket result = this.appServiceMarketMapper.selectByPrimaryKey(id);
            if (result == null) {
                log.warn("[AppServiceMarketDao.search] failed to search AppServiceMarketDao id: {}", (Object)id);
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppServiceMarketDao.search] failed to search err: {} ,id: {}", (Object)e, (Object)id);
            return null;
        }
    }

    public List<AppServiceMarket> SearchAppServiceMarketList(int pageNo, int pageSize, String creator, String marketName, String serviceName) {
        AppServiceMarketExample aje = new AppServiceMarketExample();
        aje.setOrderByClause("create_time desc");
        aje.setLimit(pageSize);
        aje.setOffset((pageNo - 1) * pageSize);
        AppServiceMarketExample.Criteria ca = aje.createCriteria();
        if (StringUtils.isNotEmpty((CharSequence)creator)) {
            System.out.println(creator);
            ca.andCreatorLike("%" + creator + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)marketName)) {
            ca.andMarketNameLike("%" + marketName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            ca.andServiceListLike("%" + serviceName + "%");
        }
        try {
            List<AppServiceMarket> list = this.appServiceMarketMapper.selectByExample(aje);
            if (list == null) {
                log.warn("[AppServiceMarketDao.SearchAppServiceMarketList failed to search");
            }
            return list;
        }
        catch (Exception e) {
            log.error("[AppServiceMarketDao.SearchAppServiceMarketList failed to search err: {}", (Object)e.toString());
            return null;
        }
    }

    public Long getTotal(String creator, String marketName, String serviceName) {
        AppServiceMarketExample aje = new AppServiceMarketExample();
        AppServiceMarketExample.Criteria ca = aje.createCriteria();
        if (StringUtils.isNotEmpty((CharSequence)creator)) {
            System.out.println(creator);
            ca.andCreatorLike("%" + creator + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)marketName)) {
            ca.andMarketNameLike("%" + marketName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            ca.andServiceListLike("%" + serviceName + "%");
        }
        try {
            Long result = this.appServiceMarketMapper.countByExample(aje);
            if (result == null) {
                log.warn("[AppServiceMarketDao.getTotal failed");
            }
            return result;
        }
        catch (Exception e) {
            log.error("[AppServiceMarketDao.getTotal failed err: {}", (Object)e.toString());
            return null;
        }
    }
}

