/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.bo;

import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmPresetMetrics;

public enum ResourceUsageMetrics {
    dockerResourceUsage("dockerResourceUsage", "docker\u8d44\u6e90\u5229\u7528\u7387", "3", AlarmPresetMetrics.container_cpu_resource_use_rate, AlarmPresetMetrics.container_mem_resource_use_rate),
    k8sResourceUsage("k8sResourceUsage", "k8s\u8d44\u6e90\u5229\u7528\u7387", "4", AlarmPresetMetrics.k8s_cpu_resource_use_rate, AlarmPresetMetrics.k8s_mem_resource_use_rate, AlarmPresetMetrics.k8s_cpu_avg_use_rate);

    private String code;
    private String message;
    private String metricsFlag;
    private AlarmPresetMetrics[] metrics;

    private ResourceUsageMetrics(String code, String message, String metricsFlag, AlarmPresetMetrics ... metrics) {
        this.code = code;
        this.message = message;
        this.metricsFlag = metricsFlag;
        this.metrics = metrics;
    }

    public String getCode() {
        return this.code;
    }

    public AlarmPresetMetrics[] getMetrics() {
        return this.metrics;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMetricsFlag() {
        return this.metricsFlag;
    }

    public void setMetricsFlag(String metricsFlag) {
        this.metricsFlag = metricsFlag;
    }

    public static ResourceUsageMetrics getErrorMetricsByMetrics(String metrics) {
        if (StringUtils.isBlank((CharSequence)metrics)) {
            return null;
        }
        for (ResourceUsageMetrics errMetrics : ResourceUsageMetrics.values()) {
            if (errMetrics.metrics == null || errMetrics.metrics.length == 0) continue;
            for (AlarmPresetMetrics ele : errMetrics.metrics) {
                if (!ele.getCode().equals(metrics)) continue;
                return errMetrics;
            }
        }
        return null;
    }

    public static String getMetricsFlagByMetrics(String metrics) {
        if (StringUtils.isBlank((CharSequence)metrics)) {
            return null;
        }
        for (ResourceUsageMetrics errMetrics : ResourceUsageMetrics.values()) {
            if (errMetrics.metrics == null || errMetrics.metrics.length == 0) continue;
            for (AlarmPresetMetrics ele : errMetrics.metrics) {
                if (!ele.getCode().equals(metrics)) continue;
                return errMetrics.getMetricsFlag();
            }
        }
        return null;
    }
}

