/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.plugin.nacos;

import cn.hutool.core.thread.ThreadUtil;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.nacos.NacosConfig;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.stream.plugin.nacos.LogFilterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LevelFilterConfigListener {
    private static final Logger log = LoggerFactory.getLogger(LevelFilterConfigListener.class);
    @Resource
    private NacosConfig nacosConfig;
    private final String logLevelFilterKey = "log.level.filter.config";
    private volatile Map<Long, LogFilterConfig> tailFilterMap = Maps.newHashMap();

    public void init() {
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtil.newNamedThreadFactory((String)"log-level-filter", (boolean)false));
        scheduledExecutor.scheduleAtFixedRate(() -> SafeRun.run(() -> this.configChangeOperate()), 0L, 1L, TimeUnit.MINUTES);
    }

    private void configChangeOperate() {
        String filterConfig = this.nacosConfig.getConfigStr("log.level.filter.config", "DEFAULT_GROUP", Constant.DEFAULT_TIME_OUT_MS.longValue());
        List logFilterConfigs = (List)Constant.GSON.fromJson(filterConfig, new TypeToken<List<LogFilterConfig>>(this){}.getType());
        if (CollectionUtils.isNotEmpty((Collection)logFilterConfigs)) {
            this.tailFilterMap = logFilterConfigs.stream().collect(Collectors.toMap(LogFilterConfig::getTailId, col -> col, (k1, k2) -> k2));
        }
    }

    public LogFilterConfig queryFilterConfig(Long tailId) {
        return this.tailFilterMap.getOrDefault(tailId, null);
    }
}

