/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.bootstrap;

import com.alibaba.nacos.client.config.utils.SnapShotSwitch;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.ozhera.log.stream.config.ConfigManager;
import org.apache.ozhera.log.stream.config.MilogConfigListener;
import org.apache.ozhera.log.stream.plugin.es.EsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class StreamManage {
    private static final Logger log = LoggerFactory.getLogger(StreamManage.class);
    @Resource
    private ConfigManager configManager;

    public void init() {
        try {
            log.info("Starting service initialization");
            if (EsPlugin.InitEsConfig()) {
                SnapShotSwitch.setIsSnapShot((Boolean)Boolean.FALSE);
                this.configManager.listenLogStreamConfig();
                this.registerGracefulShutdownHook();
            } else {
                log.error("Elasticsearch configuration initialization failed. Exiting application.");
                System.exit(ExitStatus.FAILURE.getStatus());
            }
        }
        catch (Exception e) {
            log.error("Service initialization exception", (Throwable)e);
        }
    }

    private void registerGracefulShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Graceful shutdown initiated for stream service");
            ConcurrentHashMap<Long, MilogConfigListener> listeners = this.configManager.getListeners();
            listeners.values().forEach(configListener -> configListener.getJobManager().stopAllJob());
        }));
    }

    static enum ExitStatus {
        SUCCESS(0),
        FAILURE(1);

        private final int status;

        private ExitStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

