/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.es.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.xiaomi.mone.es.EsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"storage.type"}, havingValue="es")
public class EsConfig {
    private static final Logger log = LoggerFactory.getLogger(EsConfig.class);
    @NacosValue(value="${es.trace.address}")
    private String traceAddress;
    @NacosValue(value="${es.trace.username}")
    private String traceUserName;
    @NacosValue(value="${es.trace.password}")
    private String tracePassword;

    @Bean(name={"errorEsClient"})
    public EsClient esClient() {
        try {
            EsClient esClient = new EsClient(this.traceAddress, this.traceUserName, this.tracePassword);
            log.info("init error message es");
            return esClient;
        }
        catch (Exception e) {
            log.error("init es error : ", (Throwable)e);
            return null;
        }
    }

    @Bean(name={"jaegerEsClient"})
    public EsClient jaegerEsClient() {
        try {
            EsClient esClient = new EsClient(this.traceAddress, this.traceUserName, this.tracePassword);
            log.info("init jaeger es");
            return esClient;
        }
        catch (Exception e) {
            log.error("init es error : ", (Throwable)e);
            return null;
        }
    }
}

