/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.es;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.xiaomi.mone.es.EsClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.ozhera.trace.etl.common.TimeConverter;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerAttribute;
import org.apache.ozhera.trace.etl.domain.jaegeres.JaegerProcess;
import org.apache.ozhera.trace.etl.domain.tracequery.Span;
import org.apache.ozhera.trace.etl.domain.tracequery.Trace;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceIdQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceListQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceQueryResult;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEsService {
    private static final Logger log = LoggerFactory.getLogger(QueryEsService.class);
    @Resource(name="jaegerEsClient")
    private EsClient esClient;
    private static final String SOURCE = "HERA";
    private static final String AREA = "all";
    public static final String TRACE_ID = "traceID";
    private static final String SERVICE_NAME = "serviceName";
    private static final String SERVICE_ENV = "service.env";
    private static final String PROCESS_SERVICE_NAME = "process.serviceName";
    private static final String OPERATION_NAME = "operationName";
    public static final String START_TIME_MILLIS = "startTimeMillis";
    public static final String START_TIME = "startTime";
    public static final String DURATION = "duration";
    public static final String TAGS = "tags";
    public static final String NESTED_PROCESS_TAGS = "process.tags";
    public static final String NESTED_LOG_FIELDS = "logs.fields";
    public static final String TAG_KEY = "key";
    public static final String TAG_VALUE = "value";
    public static final String[] NESTED_TAG_FIELD_LIST = new String[]{"tags", "process.tags", "logs.fields"};
    private static final Gson GSON = new GsonBuilder().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();

    public TraceQueryResult<List<String>> getOperations(String service, String index) {
        try {
            log.info("search operations by serviceName param : service=" + service + " index=" + index);
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
            sourceBuilder.size(0);
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)SERVICE_NAME, (String)service));
            TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)OPERATION_NAME).field(OPERATION_NAME)).size(10000);
            sourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
            SearchResponse response = this.esClient.search(this.buildSearchRequest(sourceBuilder, index));
            Terms terms = (Terms)response.getAggregations().get(OPERATION_NAME);
            ArrayList<String> services = new ArrayList<String>();
            for (Terms.Bucket termsBucket : terms.getBuckets()) {
                services.add(termsBucket.getKeyAsString());
            }
            return new TraceQueryResult(services, services.size());
        }
        catch (Throwable t) {
            log.error("search operations error : ", t);
            return null;
        }
    }

    public TraceQueryResult<List<Trace>> getList(TraceListQueryVo vo) {
        try {
            log.info("search trace list param : " + String.valueOf(vo));
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            long startTime = vo.getStart() == null ? 0L : TimeUnit.MICROSECONDS.toMillis(vo.getStart());
            long endTime = vo.getEnd() == null ? 0L : TimeUnit.MICROSECONDS.toMillis(vo.getEnd());
            long minDuration = StringUtils.isEmpty((CharSequence)vo.getMinDuration()) ? 0L : TimeConverter.getMicro((String)vo.getMinDuration());
            long maxDuration = StringUtils.isEmpty((CharSequence)vo.getMaxDuration()) ? 0L : TimeConverter.getMicro((String)vo.getMaxDuration());
            List<JaegerAttribute> tags = this.getTags(vo.getTags());
            tags = this.dealServerEnv(tags, vo.getServerEnv());
            if (startTime != 0L && endTime != 0L) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)START_TIME_MILLIS).gte((Object)startTime).lte((Object)endTime));
            }
            if (minDuration != 0L || maxDuration != 0L) {
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)DURATION);
                if (minDuration != 0L) {
                    rangeQueryBuilder.gte((Object)minDuration);
                }
                if (maxDuration != 0L) {
                    rangeQueryBuilder.lte((Object)maxDuration);
                }
                boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            }
            if (!Strings.isNullOrEmpty((String)vo.getOperation())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)OPERATION_NAME, (Object)vo.getOperation()));
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getService())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)PROCESS_SERVICE_NAME, (Object)vo.getService()));
            }
            if (tags != null && tags.size() > 0) {
                for (JaegerAttribute tag : tags) {
                    boolQueryBuilder.must((QueryBuilder)this.buildTagQuery(tag));
                }
            }
            TermsAggregationBuilder builder = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)TRACE_ID).size(vo.getLimit()).order(BucketOrder.aggregation((String)START_TIME, (boolean)false)).field(TRACE_ID)).subAggregation((AggregationBuilder)AggregationBuilders.max((String)START_TIME).field(START_TIME));
            sourceBuilder.aggregation((AggregationBuilder)builder);
            SearchResponse response = this.esClient.search(this.buildSearchRequest(sourceBuilder, TimeConverter.getIndexNamesByTimes((String)vo.getIndex(), (long)startTime, (long)endTime)));
            Terms terms = (Terms)response.getAggregations().get(TRACE_ID);
            ArrayList<String> traceIds = new ArrayList<String>(20);
            for (Terms.Bucket termsBucket : terms.getBuckets()) {
                traceIds.add(termsBucket.getKeyAsString());
            }
            List<Trace> traces = this.queryMultiTraceSpans(traceIds, startTime, endTime, vo.getIndex());
            return new TraceQueryResult(traces, traces.size());
        }
        catch (Throwable t) {
            log.error("search traces from es error : ", t);
            return null;
        }
    }

    public TraceQueryResult<List<Trace>> getByTraceId(TraceIdQueryVo vo) {
        String traceId = vo.getTraceId();
        long startTime = vo.getStartTime() == null ? 0L : vo.getStartTime();
        long endTime = vo.getEndTime() == null ? 0L : vo.getEndTime();
        log.info("search by traceId param : " + String.valueOf(vo) + ", traceId : " + traceId);
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)TRACE_ID, (String)traceId).boost(2.0f));
        sourceBuilder.sort(START_TIME, SortOrder.ASC);
        sourceBuilder.size(1000);
        try {
            SearchResponse response = this.esClient.search(this.buildSearchRequest(sourceBuilder, TimeConverter.getIndexNamesByTimes((String)vo.getIndex(), (long)startTime, (long)endTime)));
            ArrayList<Span> jaegerSpans = new ArrayList<Span>(response.getHits().getHits().length);
            for (SearchHit searchHit : response.getHits().getHits()) {
                Span jaegerSpanInDB = (Span)GSON.fromJson((Reader)new InputStreamReader((InputStream)searchHit.getSourceRef().streamInput()), Span.class);
                this.complateSpan(jaegerSpanInDB);
                jaegerSpans.add(jaegerSpanInDB);
            }
            Trace trace = this.getTrace(jaegerSpans);
            return new TraceQueryResult(Collections.singletonList(trace), 1);
        }
        catch (Throwable t) {
            log.error("search trace by traceId error : ", t);
            return null;
        }
    }

    private List<Trace> queryMultiTraceSpans(List<String> traceIds, long startTime, long endTime, String index) throws IOException {
        if (traceIds == null || traceIds.size() == 0) {
            return new ArrayList<Trace>();
        }
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (String traceId : traceIds) {
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            sourceBuilder.query((QueryBuilder)boolQueryBuilder);
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)TRACE_ID, (String)traceId).boost(2.0f));
            sourceBuilder.size(1000);
            sourceBuilder.terminateAfter(1000);
            sourceBuilder.sort(START_TIME_MILLIS);
            SearchRequest searchRequest = this.buildSearchRequest(sourceBuilder, TimeConverter.getIndexNamesByTimes((String)index, (long)startTime, (long)endTime));
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)false));
            multiSearchRequest.add(searchRequest);
        }
        MultiSearchResponse tracesResp = this.esClient.getEsOriginalClient().msearch(multiSearchRequest, RequestOptions.DEFAULT);
        MultiSearchResponse.Item[] responseItems = tracesResp.getResponses();
        ArrayList<Trace> jaegerTraces = new ArrayList<Trace>(responseItems.length);
        for (MultiSearchResponse.Item responseItem : responseItems) {
            SearchResponse response = responseItem.getResponse();
            ArrayList<Span> jaegerSpans = new ArrayList<Span>(response.getHits().getHits().length);
            for (int i = 0; i < response.getHits().getHits().length; ++i) {
                Span jaegerSpanInDB = (Span)GSON.fromJson((Reader)new InputStreamReader((InputStream)response.getHits().getAt(i).getSourceRef().streamInput()), Span.class);
                this.complateSpan(jaegerSpanInDB);
                jaegerSpans.add(jaegerSpanInDB);
            }
            jaegerTraces.add(this.getTrace(jaegerSpans));
        }
        return jaegerTraces;
    }

    private Trace getTrace(List<Span> spans) {
        Trace trace = new Trace();
        trace.setSpans(spans);
        if (!spans.isEmpty()) {
            trace.setTraceID(spans.get(0).getTraceID());
            trace.setProcesses(this.getProcess(spans));
        }
        trace.setSource(SOURCE);
        trace.setArea(AREA);
        return trace;
    }

    private void complateSpan(Span span) {
        span.setProcessID(span.getProcess().getServiceName());
    }

    private Map<String, JaegerProcess> getProcess(List<Span> spans) {
        HashMap<String, JaegerProcess> result = new HashMap<String, JaegerProcess>();
        for (Span span : spans) {
            result.put(span.getProcess().getServiceName(), span.getProcess());
        }
        return result;
    }

    private List<JaegerAttribute> getTags(String tags) {
        if (StringUtils.isEmpty((CharSequence)tags)) {
            return null;
        }
        ArrayList<JaegerAttribute> jaegerAttributes = new ArrayList<JaegerAttribute>();
        try {
            tags = URLDecoder.decode(tags, "UTF-8");
            Map tagMap = (Map)GSON.fromJson(tags, MAP_TYPE);
            for (String key : tagMap.keySet()) {
                JaegerAttribute attr = new JaegerAttribute();
                attr.setKey(key);
                attr.setValue((String)tagMap.get(key));
                jaegerAttributes.add(attr);
            }
        }
        catch (Throwable t) {
            log.error("parse String tags to JaegerAttribute error : ", t);
        }
        return jaegerAttributes;
    }

    private List<JaegerAttribute> dealServerEnv(List<JaegerAttribute> tags, String serverEnv) {
        if (StringUtils.isEmpty((CharSequence)serverEnv)) {
            return tags;
        }
        if (tags == null) {
            tags = new ArrayList<JaegerAttribute>();
        }
        JaegerAttribute attr = new JaegerAttribute();
        attr.setKey(SERVICE_ENV);
        attr.setValue(serverEnv);
        tags.add(attr);
        return tags;
    }

    private BoolQueryBuilder buildTagQuery(JaegerAttribute tag) {
        BoolQueryBuilder tagBoolQueryBuilder = QueryBuilders.boolQuery();
        for (String nestedTagField : NESTED_TAG_FIELD_LIST) {
            MatchQueryBuilder tagKeyQuery = QueryBuilders.matchQuery((String)String.format("%s.%s", nestedTagField, TAG_KEY), (Object)tag.getKey());
            RegexpQueryBuilder tagValueQuery = QueryBuilders.regexpQuery((String)String.format("%s.%s", nestedTagField, TAG_VALUE), (String)tag.getValue());
            tagBoolQueryBuilder.should((QueryBuilder)QueryBuilders.nestedQuery((String)nestedTagField, (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)tagKeyQuery).must((QueryBuilder)tagValueQuery), (ScoreMode)ScoreMode.Avg));
        }
        return tagBoolQueryBuilder;
    }

    private SearchRequest buildSearchRequest(SearchSourceBuilder sourceBuilder, String ... index) {
        SearchRequest searchRequest = new SearchRequest(index);
        searchRequest.source(sourceBuilder);
        return searchRequest;
    }
}

