/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.config;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.ozhera.trace.etl.domain.HeraTraceConfigVo;
import org.apache.ozhera.trace.etl.domain.HeraTraceEtlConfig;
import org.apache.ozhera.trace.etl.service.ManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TraceConfig {
    private static final Logger log = LoggerFactory.getLogger(TraceConfig.class);
    private ConcurrentHashMap<String, HeraTraceEtlConfig> heraTraceConfig = new ConcurrentHashMap();
    @Autowired
    private ManagerService managerService;

    @PostConstruct
    public void init() {
        new ScheduledThreadPoolExecutor(1).scheduleAtFixedRate(() -> {
            try {
                List all = this.managerService.getAll(new HeraTraceConfigVo());
                for (HeraTraceEtlConfig config : all) {
                    this.heraTraceConfig.put(this.getServiceName(config), config);
                }
            }
            catch (Throwable t) {
                log.error("schedule trace config error : ", t);
            }
        }, 0L, 1L, TimeUnit.HOURS);
    }

    public HeraTraceEtlConfig getConfig(String serviceName) {
        return this.heraTraceConfig.get(serviceName);
    }

    public void insert(HeraTraceEtlConfig config) {
        this.heraTraceConfig.putIfAbsent(this.getServiceName(config), config);
    }

    public void update(HeraTraceEtlConfig config) {
        this.heraTraceConfig.put(this.getServiceName(config), config);
    }

    public void delete(HeraTraceEtlConfig config) {
        this.heraTraceConfig.remove(this.getServiceName(config));
    }

    private String getServiceName(HeraTraceEtlConfig config) {
        StringBuffer sb = new StringBuffer();
        sb.append(config.getBindId()).append("-").append(config.getAppName());
        return sb.toString();
    }
}

