/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.infra.rpc.errors;

import com.xiaomi.youpin.infra.rpc.Result;
import com.xiaomi.youpin.infra.rpc.errors.ErrorScope;
import java.util.HashSet;
import java.util.Set;

public class ErrorCode {
    private static final int ERROR_CODE_PREFIX = 400;
    private static Set<Integer> allCodes = new HashSet<Integer>();
    private int code;

    ErrorCode(int code) {
        this.code = code;
    }

    public static ErrorCode createOnce(ErrorScope errorScope, int internalCode) {
        if (internalCode < 0 || internalCode >= 1000) {
            throw new IllegalArgumentException("Bad internal code range. " + internalCode);
        }
        ErrorCode code = new ErrorCode(Integer.valueOf(String.format("%03d%03d%03d", 400, errorScope.getScopeId(), internalCode)));
        if (allCodes.contains(code.getCode())) {
            throw new IllegalArgumentException("Duplicated error code defination.");
        }
        allCodes.add(code.getCode());
        return code;
    }

    public static ErrorCode fromResult(Result result) {
        return result == null ? null : new ErrorCode(result.getCode());
    }

    public int getCode() {
        return this.code;
    }
}

