/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.google.gson.Gson;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupDataRequest;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupModel;
import org.apache.ozhera.app.api.model.project.group.ProjectGroupTreeNode;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.enums.CommonError;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.service.model.project.group.ProjectGroupRequest;
import org.apache.ozhera.monitor.service.project.group.ProjectGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HeraProjectGroupController {
    private static final Logger log = LoggerFactory.getLogger(HeraProjectGroupController.class);
    @Autowired
    ProjectGroupService projectGroupService;

    @ResponseBody
    @PostMapping(value={"/api/project-group/tree/full"})
    public Result<ProjectGroupTreeNode> getFullTree(HttpServletRequest request, @RequestBody ProjectGroupRequest param) {
        Result result = this.projectGroupService.checkAuthorization(request);
        if (!result.isSuccess()) {
            return result;
        }
        log.info("getFullTree param : {}", (Object)param);
        if (param.getGroupType() == null) {
            log.error("getFullTree request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.getFullTree(param.getGroupType());
    }

    @ResponseBody
    @PostMapping(value={"/api/project-group/tree"})
    public Result<ProjectGroupTreeNode> getTreeByUser(HttpServletRequest request, @RequestBody ProjectGroupRequest param) {
        Result result = this.projectGroupService.checkAuthorization(request);
        if (!result.isSuccess()) {
            return result;
        }
        if (StringUtils.isBlank((CharSequence)param.getUser())) {
            log.error("getTreeByUser request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        log.info("getTreeByUser param : {}", (Object)param);
        if (param.getGroupType() == null) {
            log.error("getTreeByUser request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.getTreeByUser(param);
    }

    @ResponseBody
    @PostMapping(value={"/api/project-group/app"})
    public Result<List<HeraAppBaseInfoModel>> getGroupApps(HttpServletRequest request, @RequestBody ProjectGroupRequest param) {
        Result result = this.projectGroupService.checkAuthorization(request);
        if (!result.isSuccess()) {
            return result;
        }
        if (StringUtils.isBlank((CharSequence)param.getUser())) {
            log.error("getGroupApps request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        log.info("getGroupApps param : {}", (Object)param);
        if (param.getGroupType() == null) {
            log.error("getGroupApps request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.searchGroupApps(param);
    }

    @ResponseBody
    @PostMapping(value={"/api/project-group/create"})
    public Result createProjectGroup(HttpServletRequest request, @RequestBody HeraProjectGroupDataRequest param) {
        Result result;
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null && !(result = this.projectGroupService.checkAuthorization(request)).isSuccess()) {
            return result;
        }
        log.info("createProjectGroup param : {}", (Object)param);
        if (param.getType() == null || param.getRelationObjectId() == null || param.getParentGroupId() == null || StringUtils.isBlank((CharSequence)param.getName())) {
            log.error("createProjectGroup request param error!param:{}", (Object)param);
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        Result integerResult = this.projectGroupService.create(param);
        log.info("createProjectGroup param : {}, result : {}", (Object)param, (Object)new Gson().toJson((Object)integerResult));
        return integerResult;
    }

    @ResponseBody
    @PostMapping(value={"/api/project-group/update"})
    public Result updateProjectGroup(HttpServletRequest request, @RequestBody HeraProjectGroupDataRequest param) {
        Result result;
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null && !(result = this.projectGroupService.checkAuthorization(request)).isSuccess()) {
            return result;
        }
        log.info("updateProjectGroup param : {}", (Object)param);
        if (param.getId() == null) {
            log.error("updateProjectGroup request param error!param:{}", (Object)param);
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.update(param);
    }

    @ResponseBody
    @DeleteMapping(value={"/api/project-group/delete/{id}"})
    public Result deleteProjectGroup(HttpServletRequest request, @PathVariable(value="id") Integer id) {
        Result result;
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null && !(result = this.projectGroupService.checkAuthorization(request)).isSuccess()) {
            return result;
        }
        log.info("deleteProjectGroup id : {}", (Object)id);
        if (id == null) {
            log.error("deleteProjectGroup request param error! id is null!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.delete(id);
    }

    @ResponseBody
    @PostMapping(value={"/view/project-group/tree/full"})
    public Result<ProjectGroupTreeNode> vieFullTree(HttpServletRequest request, @RequestBody ProjectGroupRequest param) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return Result.fail((CommonError)CommonError.UNAUTHORIZED);
        }
        log.info("vieFullTree param : {}", (Object)param);
        if (param.getGroupType() == null) {
            log.error("vieFullTree request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.getFullTree(param.getGroupType());
    }

    @ResponseBody
    @PostMapping(value={"/view/project-group/tree"})
    public Result<ProjectGroupTreeNode> viewTreeByUser(HttpServletRequest request, @RequestBody ProjectGroupRequest param) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return Result.fail((CommonError)CommonError.UNAUTHORIZED);
        }
        log.info("viewTreeByUser param : {}", (Object)param);
        if (param.getGroupType() == null) {
            log.error("getTreeByUser request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        param.setUser(userInfo.genFullAccount());
        return this.projectGroupService.getTreeByUser(param);
    }

    @ResponseBody
    @PostMapping(value={"/view/project-group/apps"})
    public Result<List<AppMonitor>> viewGroupApps(HttpServletRequest request, @RequestBody ProjectGroupRequest param) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return Result.fail((CommonError)CommonError.UNAUTHORIZED);
        }
        String user = userInfo.genFullAccount();
        param.setUser(user);
        log.info("viewGroupApps param : {}", (Object)param);
        if (param.getGroupType() == null) {
            log.error("viewGroupApps request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.searchMyApps(param);
    }

    @ResponseBody
    @PostMapping(value={"/view/project-group/childs"})
    public Result<List<HeraProjectGroupModel>> searchChildGroups(HttpServletRequest request, @RequestBody ProjectGroupRequest param) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return Result.fail((CommonError)CommonError.UNAUTHORIZED);
        }
        String user = userInfo.genFullAccount();
        param.setUser(user);
        log.info("searchChildGroups param : {}", (Object)param);
        if (param.getGroupType() == null) {
            log.error("searchChildGroups request param error! no group type found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        if (param.getProjectGroupId() == null) {
            log.error("searchChildGroups request param error! no projectGroupId found!");
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        return this.projectGroupService.searchChildGroups(param);
    }
}

