/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.prometheus.client.multi;

import com.xiaomi.youpin.prometheus.client.MetricsManager;
import com.xiaomi.youpin.prometheus.client.PrometheusCounter;
import com.xiaomi.youpin.prometheus.client.PrometheusGauge;
import com.xiaomi.youpin.prometheus.client.PrometheusHistogram;
import com.xiaomi.youpin.prometheus.client.XmCounter;
import com.xiaomi.youpin.prometheus.client.XmGauge;
import com.xiaomi.youpin.prometheus.client.XmHistogram;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutiPrometheus
implements MetricsManager {
    private static final Logger log = LoggerFactory.getLogger(MutiPrometheus.class);
    public static final int CONST_LABELS_NUM = 2;
    private Map<String, String> constLabels;
    private Map<String, Object> prometheusMetrics;
    private Map<String, Object> prometheusTypeMetrics;
    private CollectorRegistry registry;
    private byte[] lock = new byte[0];
    private byte[] typeLock = new byte[0];

    public MutiPrometheus() {
        this.prometheusMetrics = new ConcurrentHashMap<String, Object>();
        this.prometheusTypeMetrics = new ConcurrentHashMap<String, Object>();
    }

    public MutiPrometheus(CollectorRegistry registry) {
        this.prometheusMetrics = new ConcurrentHashMap<String, Object>();
        this.prometheusTypeMetrics = new ConcurrentHashMap<String, Object>();
        this.registry = registry;
    }

    public Map<String, String> getConstLabels() {
        return this.constLabels;
    }

    public Map<String, String> setConstLabels(Map<String, String> constLabels) {
        this.constLabels = constLabels;
        return this.constLabels;
    }

    public Map<String, Object> getPrometheusMetrics() {
        return this.prometheusMetrics;
    }

    public Map<String, Object> getPrometheusTypeMetrics() {
        return this.prometheusTypeMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmCounter newCounter(String metricName, String ... labelName) {
        if (this.prometheusTypeMetrics.containsKey(metricName)) {
            return (XmCounter)this.prometheusTypeMetrics.get(metricName);
        }
        byte[] byArray = this.typeLock;
        synchronized (this.typeLock) {
            PrometheusCounter prometheusCounter = new PrometheusCounter(this.getCounter(metricName, labelName), labelName, null, this);
            this.prometheusTypeMetrics.put(metricName, prometheusCounter);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return prometheusCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmGauge newGauge(String metricName, String ... labelName) {
        if (this.prometheusTypeMetrics.containsKey(metricName)) {
            return (XmGauge)this.prometheusTypeMetrics.get(metricName);
        }
        byte[] byArray = this.typeLock;
        synchronized (this.typeLock) {
            PrometheusGauge prometheusGauge = new PrometheusGauge(this.getGauge(metricName, labelName), labelName, null, this);
            this.prometheusTypeMetrics.put(metricName, prometheusGauge);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return prometheusGauge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmHistogram newHistogram(String metricName, double[] bucket, String ... labelNames) {
        if (this.prometheusTypeMetrics.containsKey(metricName)) {
            return (XmHistogram)this.prometheusTypeMetrics.get(metricName);
        }
        byte[] byArray = this.typeLock;
        synchronized (this.typeLock) {
            PrometheusHistogram prometheusHistogram = new PrometheusHistogram(this.getHistogram(metricName, bucket, labelNames), labelNames, null, this);
            this.prometheusTypeMetrics.put(metricName, prometheusHistogram);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return prometheusHistogram;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter getCounter(String metricName, String ... labelName) {
        if (this.constLabels.size() != 2) {
            return null;
        }
        try {
            if (this.prometheusMetrics.containsKey(metricName)) {
                return (Counter)this.prometheusMetrics.get(metricName);
            }
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelName));
                String[] finalValue = mylist.toArray(new String[mylist.size()]);
                Counter newCounter = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(metricName)).namespace(this.constLabels.get("group") + (String)("".equals(this.constLabels.get("service")) ? "" : "_" + this.constLabels.get("service")))).labelNames(finalValue)).help(metricName)).register(this.registry);
                this.prometheusMetrics.put(metricName, newCounter);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return newCounter;
            }
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Gauge getGauge(String metricName, String ... labelName) {
        if (this.constLabels.size() != 2) {
            return null;
        }
        try {
            if (this.prometheusMetrics.containsKey(metricName)) {
                return (Gauge)this.prometheusMetrics.get(metricName);
            }
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelName));
                String[] finalValue = mylist.toArray(new String[mylist.size()]);
                Gauge newGauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(metricName)).namespace(this.constLabels.get("group") + (String)("".equals(this.constLabels.get("service")) ? "" : "_" + this.constLabels.get("service")))).labelNames(finalValue)).help(metricName)).register(this.registry);
                this.prometheusMetrics.put(metricName, newGauge);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return newGauge;
            }
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Histogram getHistogram(String metricName, double[] buckets, String ... labelNames) {
        if (this.constLabels.size() != 2) {
            return null;
        }
        try {
            if (this.prometheusMetrics.containsKey(metricName)) {
                return (Histogram)this.prometheusMetrics.get(metricName);
            }
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                ArrayList<String> mylist = new ArrayList<String>(Arrays.asList(labelNames));
                String[] finalValue = mylist.toArray(new String[mylist.size()]);
                Histogram newHistogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().buckets(buckets).name(metricName)).namespace(this.constLabels.get("group") + (String)("".equals(this.constLabels.get("service")) ? "" : "_" + this.constLabels.get("service")))).labelNames(finalValue)).help(metricName)).register(this.registry);
                this.prometheusMetrics.put(metricName, newHistogram);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newHistogram;
            }
        }
        catch (Throwable throwable) {
            log.warn(throwable.getMessage());
            return null;
        }
    }
}

