/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShard;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.InternalAggregations;

public abstract class SearchProgressListener {
    private static final Logger logger = LogManager.getLogger(SearchProgressListener.class);
    public static final SearchProgressListener NOOP = new SearchProgressListener(){};
    private List<SearchShard> shards;

    protected void onListShards(List<SearchShard> shards, List<SearchShard> skippedShards, SearchResponse.Clusters clusters, boolean fetchPhase) {
    }

    protected void onQueryResult(int shardIndex) {
    }

    protected void onQueryFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    protected void onPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
    }

    protected void onFinalReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
    }

    protected void onFetchResult(int shardIndex) {
    }

    protected void onFetchFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    final void notifyListShards(List<SearchShard> shards, List<SearchShard> skippedShards, SearchResponse.Clusters clusters, boolean fetchPhase) {
        this.shards = shards;
        try {
            this.onListShards(shards, skippedShards, clusters, fetchPhase);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on list shards", new Object[0]), (Throwable)e);
        }
    }

    final void notifyQueryResult(int shardIndex) {
        try {
            this.onQueryResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on query result", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    final void notifyQueryFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        try {
            this.onQueryFailure(shardIndex, shardTarget, exc);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on query failure", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    final void notifyPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
        try {
            this.onPartialReduce(shards, totalHits, aggs, reducePhase);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on partial reduce", new Object[0]), (Throwable)e);
        }
    }

    protected final void notifyFinalReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
        try {
            this.onFinalReduce(shards, totalHits, aggs, reducePhase);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("Failed to execute progress listener on reduce", new Object[0]), (Throwable)e);
        }
    }

    final void notifyFetchResult(int shardIndex) {
        try {
            this.onFetchResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on fetch result", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    final void notifyFetchFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        try {
            this.onFetchFailure(shardIndex, shardTarget, exc);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] Failed to execute progress listener on fetch failure", (Object)this.shards.get(shardIndex)), (Throwable)e);
        }
    }

    static List<SearchShard> buildSearchShards(List<? extends SearchPhaseResult> results) {
        List lst = results.stream().filter(Objects::nonNull).map(SearchPhaseResult::getSearchShardTarget).map(e -> new SearchShard(e.getClusterAlias(), e.getShardId())).collect(Collectors.toList());
        return Collections.unmodifiableList(lst);
    }

    static List<SearchShard> buildSearchShards(GroupShardsIterator<SearchShardIterator> its) {
        List lst = StreamSupport.stream(its.spliterator(), false).map(e -> new SearchShard(e.getClusterAlias(), e.shardId())).collect(Collectors.toList());
        return Collections.unmodifiableList(lst);
    }
}

