/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.kafka;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.ozhera.trace.etl.bo.MqConfig;
import org.apache.ozhera.trace.etl.extension.kafka.KafkaConfigure;

public class KafkaConfigure9093
implements KafkaConfigure {
    @NacosValue(value="${java.security.auth.login.config}")
    private String authLoginConfigLocation;
    @NacosValue(value="${sasl.mechanism}")
    private String saslMechanism;
    @NacosValue(value="${ssl.truststore.location}")
    private String sslTruststoreLocation;
    @NacosValue(value="${kafka.username}")
    private String saslUserName;
    @NacosValue(value="${kafka.password}")
    private String saslPassword;
    @NacosValue(value="${kafka.poll.records}")
    private int kafkaPollRecords;

    private void configureSasl() {
        if (null == System.getProperty("java.security.auth.login.config") && StringUtils.isEmpty((CharSequence)this.saslUserName) && StringUtils.isEmpty((CharSequence)this.saslPassword)) {
            System.setProperty("java.security.auth.login.config", this.authLoginConfigLocation);
        }
    }

    @Override
    public Properties createProducerProperties(MqConfig<ConsumerRecords<String, String>> config) {
        this.configureSasl();
        Properties props = new Properties();
        props.put("bootstrap.servers", config.getNameSerAddr());
        props.put("ssl.truststore.location", this.sslTruststoreLocation);
        props.put("ssl.truststore.password", "KafkaOnsClient");
        props.put("security.protocol", "SASL_SSL");
        if (StringUtils.isNotEmpty((CharSequence)this.saslUserName) && StringUtils.isNotEmpty((CharSequence)this.saslPassword)) {
            String prefix = "org.apache.kafka.common.security.scram.ScramLoginModule";
            if ("PLAIN".equalsIgnoreCase(this.saslMechanism)) {
                prefix = "org.apache.kafka.common.security.plain.PlainLoginModule";
            }
            String jaasConfig = String.format("%s required username=\"%s\" password=\"%s\";", prefix, this.saslUserName, this.saslPassword);
            props.put("sasl.jaas.config", jaasConfig);
        }
        props.put("sasl.mechanism", this.saslMechanism);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("max.block.ms", (Object)30000);
        props.put("retries", (Object)5);
        props.put("reconnect.backoff.ms", (Object)3000);
        props.put("ssl.endpoint.identification.algorithm", "");
        return props;
    }

    @Override
    public Properties createConsumerProperties(MqConfig<ConsumerRecords<String, String>> config) {
        this.configureSasl();
        Properties props = new Properties();
        props.put("bootstrap.servers", config.getNameSerAddr());
        props.put("ssl.truststore.location", this.sslTruststoreLocation);
        props.put("ssl.truststore.password", "KafkaOnsClient");
        props.put("security.protocol", "SASL_SSL");
        if (StringUtils.isNotEmpty((CharSequence)this.saslUserName) && StringUtils.isNotEmpty((CharSequence)this.saslPassword)) {
            String prefix = "org.apache.kafka.common.security.scram.ScramLoginModule";
            if ("PLAIN".equalsIgnoreCase(this.saslMechanism)) {
                prefix = "org.apache.kafka.common.security.plain.PlainLoginModule";
            }
            String jaasConfig = String.format("%s required username=\"%s\" password=\"%s\";", prefix, this.saslUserName, this.saslPassword);
            props.put("sasl.jaas.config", jaasConfig);
        }
        props.put("sasl.mechanism", this.saslMechanism);
        props.put("session.timeout.ms", (Object)30000);
        props.put("max.partition.fetch.bytes", (Object)32000);
        props.put("fetch.max.bytes", (Object)32000);
        props.put("max.poll.records", (Object)this.kafkaPollRecords);
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("group.id", config.getConsumerGroup());
        props.put("ssl.endpoint.identification.algorithm", "");
        return props;
    }
}

