/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

public class MoneRandomAccessFile
extends RandomAccessFile {
    private byte[] buffer;
    private int buf_end = 0;
    private int buf_pos = 0;
    private long real_pos = 0L;
    private final int BUF_SIZE;

    public MoneRandomAccessFile(String filename, String mode, int bufSize) throws IOException {
        super(filename, mode);
        this.invalidate();
        this.BUF_SIZE = bufSize;
        this.buffer = new byte[this.BUF_SIZE];
    }

    public MoneRandomAccessFile(File file, String mode, int bufsize) throws IOException {
        this(file.getAbsolutePath(), mode, bufsize);
    }

    @Override
    public final int read() throws IOException {
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        return this.buffer[this.buf_pos++] & 0xFF;
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, this.BUF_SIZE);
        if (n >= 0) {
            this.real_pos += (long)n;
            this.buf_end = n;
            this.buf_pos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.buf_end = 0;
        this.buf_pos = 0;
        this.real_pos = super.getFilePointer();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int leftover = this.buf_end - this.buf_pos;
        if (len <= leftover) {
            System.arraycopy(this.buffer, this.buf_pos, b, off, len);
            this.buf_pos += len;
            return len;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
        }
        return len;
    }

    @Override
    public long getFilePointer() throws IOException {
        long l = this.real_pos;
        return l - (long)this.buf_end + (long)this.buf_pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        long n = this.real_pos - pos;
        if (n >= 0L && n <= (long)this.buf_end) {
            this.buf_pos = (int)((long)this.buf_end - n);
        } else {
            super.seek(pos);
            this.invalidate();
        }
    }

    public final String getNextLine() throws IOException {
        if (this.buf_end - this.buf_pos <= 0 && this.fillBuffer() < 0) {
            return null;
        }
        int lineEnd = -1;
        for (int i = this.buf_pos; i < this.buf_end; ++i) {
            if (this.buffer[i] == 10) {
                lineEnd = i;
                break;
            }
            if (i - this.buf_pos <= 0 || this.buffer[i - 1] != 13) continue;
            lineEnd = i - 1;
            break;
        }
        if (lineEnd < 0) {
            StringBuffer input = new StringBuffer();
            int c = -1;
            int lastC = 0;
            int cCount = 0;
            boolean eol = false;
            while (!eol) {
                c = this.read();
                if (c == -1) {
                    if (cCount++ <= 10) continue;
                    eol = true;
                    continue;
                }
                if (c == 10) {
                    eol = true;
                    continue;
                }
                if (lastC == 13) {
                    eol = true;
                    continue;
                }
                input.append((char)c);
                lastC = c;
            }
            if (c == -1 && input.length() == 0) {
                return null;
            }
            return new String(input.toString().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        }
        String str = lineEnd > 0 && this.buffer[lineEnd] == 10 && this.buffer[lineEnd - 1] == 13 && lineEnd - this.buf_pos - 1 >= 0 ? new String(this.buffer, this.buf_pos, lineEnd - this.buf_pos - 1, StandardCharsets.UTF_8) : new String(this.buffer, this.buf_pos, lineEnd - this.buf_pos, StandardCharsets.UTF_8);
        this.buf_pos = lineEnd + 1;
        return str;
    }
}

