/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file;

import com.google.common.collect.Lists;
import com.xiaomi.mone.file.ILogFile;
import com.xiaomi.mone.file.MoneRandomAccessFile;
import com.xiaomi.mone.file.ReadEvent;
import com.xiaomi.mone.file.ReadListener;
import com.xiaomi.mone.file.ReadResult;
import com.xiaomi.mone.file.common.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFile
implements ILogFile {
    private static final Logger log = LoggerFactory.getLogger(LogFile.class);
    private String file;
    private MoneRandomAccessFile raf;
    private ReadListener listener;
    private volatile boolean stop;
    private volatile boolean reOpen;
    private volatile boolean reFresh;
    private volatile boolean exceptionFinish;
    private int beforePointerHashCode;
    private volatile long pointer;
    private long lineNumber;
    private volatile long maxPointer;
    private String md5;

    public LogFile() {
    }

    public LogFile(String file, ReadListener listener) {
        this.file = file;
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = this.readPointer();
    }

    public LogFile(String file, ReadListener listener, long pointer, long lineNumber) {
        this.file = file;
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = pointer;
        this.lineNumber = lineNumber;
    }

    private void open() {
        try {
            this.raf = new MoneRandomAccessFile(this.file, "r", 4096);
            this.reOpen = false;
            this.reFresh = false;
        }
        catch (FileNotFoundException e) {
            log.error("open file FileNotFoundException", (Throwable)e);
        }
        catch (IOException e) {
            log.error("open file IOException", (Throwable)e);
        }
    }

    @Override
    public void readLine() throws Exception {
        do {
            this.open();
            try {
                log.info("open file:{},pointer:{},fileKey:{}", new Object[]{this.file, this.pointer, FileUtils.fileKey(new File(this.file))});
                if (this.pointer > this.raf.length()) {
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                }
            }
            catch (Exception e) {
                log.error("file.length() IOException, file:{}", (Object)this.file, (Object)e);
            }
            this.raf.seek(this.pointer);
            log.info("start readLine file:{},pointer:{}", (Object)this.file, (Object)this.pointer);
            while (true) {
                String line;
                if (null != (line = this.raf.getNextLine()) && this.lineNumber == 0L && this.pointer == 0L) {
                    String hashLine = line.length() > 100 ? line.substring(0, 100) : line;
                    this.beforePointerHashCode = hashLine.hashCode();
                }
                line = this.lineCutOff(line);
                if (this.reFresh) {
                    log.info("readline reFresh:{},pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, FileUtils.fileKey(new File(this.file))});
                    break;
                }
                if (this.reOpen) {
                    log.info("readline reOpen:{},pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, FileUtils.fileKey(new File(this.file))});
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                    break;
                }
                if (this.stop) {
                    log.info("readline stop:{},pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, FileUtils.fileKey(new File(this.file))});
                    break;
                }
                if (this.contentHasCutting(line)) {
                    this.reOpen = true;
                    this.pointer = 0L;
                    this.lineNumber = 0L;
                    log.info("readline file:{} content have been cut, goto reOpen file,pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, FileUtils.fileKey(new File(this.file))});
                    break;
                }
                if (this.listener.isContinue(line)) {
                    log.debug("readline isBreak:{},pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, FileUtils.fileKey(new File(this.file))});
                    continue;
                }
                try {
                    this.pointer = this.raf.getFilePointer();
                    this.maxPointer = this.raf.length();
                }
                catch (IOException e) {
                    log.error("file.length() IOException, file:{}", (Object)this.file, (Object)e);
                }
                ReadResult readResult = new ReadResult();
                readResult.setLines(Lists.newArrayList((Object[])new String[]{line}));
                readResult.setPointer(this.pointer);
                readResult.setFileMaxPointer(this.maxPointer);
                readResult.setLineNumber(++this.lineNumber);
                ReadEvent event = new ReadEvent(readResult);
                this.listener.onEvent(event);
            }
            this.raf.close();
        } while (!this.stop);
        log.info("read file stop:{},pointer:{},lineNumber:{},fileKey:{}", new Object[]{this.file, this.pointer, this.lineNumber, FileUtils.fileKey(new File(this.file))});
    }

    @Override
    public void initLogFile(String file, ReadListener listener, long pointer, long lineNumber) {
        this.file = file;
        this.md5 = this.md5(file);
        this.listener = listener;
        this.pointer = pointer;
        this.lineNumber = lineNumber;
    }

    @Override
    public void setExceptionFinish() {
        this.exceptionFinish = true;
    }

    @Override
    public boolean getExceptionFinish() {
        return this.exceptionFinish;
    }

    private String lineCutOff(String line) {
        if (null != line && line.length() > 1100000) {
            line = line.substring(0, 1100000);
        }
        return line;
    }

    private boolean contentHasCutting(String line) throws IOException {
        long mPointer;
        long currentFileMaxPointer;
        if (null != line) {
            return false;
        }
        try {
            currentFileMaxPointer = this.raf.length();
            if (currentFileMaxPointer == 0L) {
                this.raf.getFD().sync();
                TimeUnit.MILLISECONDS.sleep(30L);
                currentFileMaxPointer = this.raf.length();
            }
        }
        catch (IOException e) {
            log.error("get fileMaxPointer IOException", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.error("get fileMaxPointer InterruptedException", (Throwable)e);
            return false;
        }
        long l = mPointer = this.maxPointer > 70000L ? this.maxPointer - 700L : this.maxPointer;
        if (currentFileMaxPointer < mPointer) {
            this.maxPointer = currentFileMaxPointer;
            return true;
        }
        return false;
    }

    public void shutdown() {
        try {
            this.stop = true;
            Files.write(Paths.get("/tmp/" + this.md5, new String[0]), String.valueOf(this.pointer).getBytes(), new OpenOption[0]);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
        }
    }

    public long readPointer() {
        try {
            byte[] data = Files.readAllBytes(Paths.get("/tmp/" + this.md5, new String[0]));
            return Long.valueOf(new String(data));
        }
        catch (Throwable e) {
            log.error(e.getMessage());
            return 0L;
        }
    }

    public String md5(String msg) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(msg.getBytes());
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(2 * digest.length);
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString().toUpperCase();
    }

    public String getFile() {
        return this.file;
    }

    @Override
    public void setStop(boolean stop) {
        this.stop = stop;
    }

    @Override
    public void setReOpen(boolean reOpen) {
        this.reOpen = reOpen;
    }

    public void setReFresh(boolean reFresh) {
        this.reFresh = reFresh;
    }

    public int getBeforePointerHashCode() {
        return this.beforePointerHashCode;
    }

    public long getPointer() {
        return this.pointer;
    }

    public long getMaxPointer() {
        return this.maxPointer;
    }
}

