/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;

public class LibraryInfo {
    private final String libraryName;
    private final String engine;
    private final String description;
    private final List<Map<String, Object>> functions;
    private final String libraryCode;
    public static final Builder<LibraryInfo> LIBRARY_BUILDER = new Builder<LibraryInfo>(){

        @Override
        public LibraryInfo build(Object data) {
            List objectList = (List)data;
            String libname = BuilderFactory.STRING.build(objectList.get(1));
            String engine = BuilderFactory.STRING.build(objectList.get(3));
            String desc = BuilderFactory.STRING.build(objectList.get(5));
            List rawFunctions = (List)objectList.get(7);
            List<Map<String, Object>> functions = rawFunctions.stream().map(o -> BuilderFactory.ENCODED_OBJECT_MAP.build(o)).collect(Collectors.toList());
            if (objectList.size() <= 8) {
                return new LibraryInfo(libname, engine, desc, functions);
            }
            String code = BuilderFactory.STRING.build(objectList.get(9));
            return new LibraryInfo(libname, engine, desc, functions, code);
        }
    };

    public LibraryInfo(String libraryName, String engineName, String description, List<Map<String, Object>> functions) {
        this(libraryName, engineName, description, functions, null);
    }

    public LibraryInfo(String libraryName, String engineName, String description, List<Map<String, Object>> functions, String code) {
        this.libraryName = libraryName;
        this.engine = engineName;
        this.description = description;
        this.functions = functions;
        this.libraryCode = code;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Map<String, Object>> getFunctions() {
        return this.functions;
    }

    public String getLibraryCode() {
        return this.libraryCode;
    }
}

