/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.auth;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.client.config.utils.MD5;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.enums.CommonError;
import org.apache.ozhera.app.redis.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationService.class);
    @NacosValue(value="${hera.auth.user}", autoRefreshed=true)
    private String userName;
    @NacosValue(value="${hera.auth.pwd}", autoRefreshed=true)
    private String passWord;
    @NacosValue(value="${hera.auth.secret}", autoRefreshed=true)
    private String secret;
    @Autowired
    RedisService redisService;
    private static int tokenAccessSequence = 0;
    private static int tokenTimeLimit = 600;
    private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final ReentrantLock lock = new ReentrantLock();

    public Result fetchToken(String user, String sign, Long timestamp) {
        log.info("fetchToken user : {} , timestamp : {}", (Object)user, (Object)df.format(timestamp));
        if (StringUtils.isBlank((CharSequence)user) || StringUtils.isBlank((CharSequence)sign) || timestamp == null) {
            log.error("fetchToken param error! user : {}, sign : {}, timestamp :{}", new Object[]{user, sign, timestamp});
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        Long currentTime = System.currentTimeMillis();
        if (currentTime - timestamp < 0L || currentTime - timestamp > 30000L) {
            log.error("fetchToken param time expired! currentTimeStamp : {}, param timestamp :{}", (Object)currentTime, (Object)timestamp);
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        if (!this.userName.equals(user)) {
            log.info("fetchToken param user error! user : {} ", (Object)user);
            return Result.fail((CommonError)CommonError.NO_AUTHORIZATION);
        }
        String md5Pwd = MD5.getInstance().getMD5String(this.passWord);
        StringBuilder secretPwdBuffer = new StringBuilder();
        secretPwdBuffer.append(this.userName).append(md5Pwd).append(timestamp);
        String signSource = MD5.getInstance().getMD5String(secretPwdBuffer.toString());
        if (!signSource.equals(sign)) {
            log.info("fetchToken param sign error! user : {} , sign : {}", (Object)user, (Object)sign);
            return Result.fail((CommonError)CommonError.NO_AUTHORIZATION);
        }
        return Result.success((Object)this.generateToken(this.userName));
    }

    private String generateToken(String userName) {
        StringBuilder builder = new StringBuilder();
        builder.append("token:").append(userName).append(":").append(System.currentTimeMillis()).append(":").append(this.secret);
        String tokenString = MD5.getInstance().getMD5String(builder.toString());
        try {
            this.redisService.set(tokenString, String.valueOf(tokenAccessSequence), tokenTimeLimit);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return tokenString;
    }

    public Result checkAuthorization(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            log.error("checkAuthorization error!token is null!");
            return Result.fail((CommonError)CommonError.NO_TOKEN);
        }
        String result = null;
        try {
            result = this.redisService.get(token);
        }
        catch (Exception e) {
            log.error("checkAuthorization redis exception!" + e.getMessage(), (Throwable)e);
            return Result.fail((CommonError)CommonError.UnknownError);
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error("checkAuthorization token is error or expired!");
            return Result.fail((CommonError)CommonError.INVALID_TOKEN);
        }
        return Result.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer checkAuthorizationWithSeq(String token, Integer accessSeq) {
        this.lock.lock();
        try {
            if (StringUtils.isBlank((CharSequence)token)) {
                log.error("checkAuthorization error!token is null!");
                Integer n = null;
                return n;
            }
            if (this.redisService.get(token) == null) {
                log.error("checkAuthorization token is error or expired!");
                Integer n = null;
                return n;
            }
            String accessNumStr = this.redisService.get(token);
            Integer accessNum = Integer.valueOf(accessNumStr);
            if (accessSeq <= accessNum) {
                log.error("token accessSeq has expired!accessSeq:{}, currentNum:{}", (Object)accessSeq, (Object)accessNum);
                Integer n = null;
                return n;
            }
            if (accessSeq - accessNum > 1) {
                log.error("token accessSeq error!accessSeq:{}, currentNum:{}", (Object)accessSeq, (Object)accessNum);
                Integer n = null;
                return n;
            }
            long ttl = this.redisService.ttl(token);
            this.redisService.set(token, String.valueOf(accessSeq), ttl);
            Integer n = accessSeq + 1;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

