/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.enums;

import java.util.Arrays;
import java.util.List;
import org.apache.ozhera.log.api.filter.RateLimitStrategy;
import org.apache.ozhera.log.api.model.meta.FilterDefine;

public enum RateLimitEnum {
    RATE_LIMIT_FAST("FAST"),
    RATE_LIMIT_MEDIUM("MEDIUM"),
    RATE_LIMIT_SLOW("SLOW"),
    RATE_LIMIT_NONE("NONE");

    private final String rateLimit;

    private RateLimitEnum(String rateLimit) {
        this.rateLimit = rateLimit;
    }

    public static RateLimitEnum queryByRateLimit(String rateLimit) {
        return Arrays.stream(RateLimitEnum.values()).filter(rateLimitEnum -> rateLimit.equals(rateLimitEnum.getRateLimit())).findFirst().orElse(null);
    }

    public static String consTailRate(List<FilterDefine> defines) {
        if (defines == null) {
            return RATE_LIMIT_MEDIUM.getRateLimit();
        }
        for (FilterDefine define : defines) {
            if (define == null || define.getCode() == null || !define.getCode().startsWith("RATELIMITCODE")) continue;
            if (define.getCode().equals(RateLimitStrategy.REGINAL_FAST.getCode())) {
                return RATE_LIMIT_FAST.getRateLimit();
            }
            if (define.getCode().equals(RateLimitStrategy.REGINAL_MEDIUM.getCode())) {
                return RATE_LIMIT_MEDIUM.getRateLimit();
            }
            if (define.getCode().equals(RateLimitStrategy.REGINAL_SLOW.getCode())) {
                return RATE_LIMIT_SLOW.getRateLimit();
            }
            if (!define.getCode().equals(RateLimitStrategy.REGINAL_NONE.getCode())) continue;
            return RATE_LIMIT_NONE.getRateLimit();
        }
        return RATE_LIMIT_MEDIUM.getRateLimit();
    }

    public String getRateLimit() {
        return this.rateLimit;
    }
}

