/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.odps;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.support.odps.JSONWritable;
import com.alibaba.fastjson2.util.IOUtils;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.udf.UDF;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class JSONExtractScalar
extends UDF {
    static final byte[] BYTES_TRUE = "true".getBytes(StandardCharsets.UTF_8);
    static final byte[] BYTES_FALSE = "false".getBytes(StandardCharsets.UTF_8);
    static final byte[] BYTES_NULL = "null".getBytes(StandardCharsets.UTF_8);
    final JSONPath path;
    JSONWritable text = new JSONWritable();
    ExtractValueConsumer valueConsumer = new ExtractValueConsumer();

    public JSONExtractScalar(String path) {
        this.path = JSONPath.of((String)path);
    }

    public Writable eval(Text input) {
        JSONReader parser = JSONReader.of((byte[])input.getBytes(), (int)0, (int)input.getLength(), (Charset)StandardCharsets.UTF_8);
        this.path.extractScalar(parser, (ValueConsumer)this.valueConsumer);
        return this.text;
    }

    class ExtractValueConsumer
    implements ValueConsumer {
        ExtractValueConsumer() {
        }

        public void accept(byte[] bytes, int off, int len) {
            JSONExtractScalar.this.text.bytes = bytes;
            JSONExtractScalar.this.text.off = off;
            JSONExtractScalar.this.text.length = len;
        }

        public void acceptNull() {
            JSONExtractScalar.this.text.set(BYTES_NULL);
        }

        public void accept(boolean val) {
            JSONExtractScalar.this.text.set(val ? BYTES_TRUE : BYTES_FALSE);
        }

        public void accept(int val) {
            int size = val < 0 ? IOUtils.stringSize((int)(-val)) + 1 : IOUtils.stringSize((int)val);
            JSONExtractScalar.this.text.setCapacity(size, false);
            byte[] bytes = JSONExtractScalar.this.text.bytes;
            IOUtils.getChars((int)val, (int)size, (byte[])bytes);
            JSONExtractScalar.this.text.length = size;
        }

        public void accept(long val) {
            int size = val < 0L ? IOUtils.stringSize((long)(-val)) + 1 : IOUtils.stringSize((long)val);
            JSONExtractScalar.this.text.setCapacity(size, false);
            byte[] bytes = JSONExtractScalar.this.text.bytes;
            IOUtils.getChars((long)val, (int)size, (byte[])bytes);
            JSONExtractScalar.this.text.length = size;
        }

        public void accept(Number val) {
            if (val instanceof Integer) {
                this.accept(val.intValue());
                return;
            }
            if (val instanceof Long) {
                this.accept(val.longValue());
                return;
            }
            String str = val.toString();
            JSONExtractScalar.this.text.set(str);
        }

        public void accept(String val) {
            JSONExtractScalar.this.text.set(val);
        }

        public void accept(Map object) {
            JSONExtractScalar.this.text.set(JSON.toJSONBytes((Object)object));
        }

        public void accept(List array) {
            JSONExtractScalar.this.text.set(JSON.toJSONBytes((Object)array));
        }
    }
}

