/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.xiaomi.youpin.docean.anno.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.domain.AnalyseLog;
import org.apache.ozhera.log.manager.mapper.MilogAnalyseDashboardGraphRefMapper;
import org.apache.ozhera.log.manager.mapper.MilogAnalyseDashboardMapper;
import org.apache.ozhera.log.manager.mapper.MilogAnalyseGraphMapper;
import org.apache.ozhera.log.manager.mapper.MilogAnalyseGraphTypeMapper;
import org.apache.ozhera.log.manager.model.convert.DGRefConvert;
import org.apache.ozhera.log.manager.model.convert.DashboardConvert;
import org.apache.ozhera.log.manager.model.convert.GraphConvert;
import org.apache.ozhera.log.manager.model.convert.GraphTypeConvert;
import org.apache.ozhera.log.manager.model.dto.DashboardDTO;
import org.apache.ozhera.log.manager.model.dto.DashboardGraphDTO;
import org.apache.ozhera.log.manager.model.dto.GraphDTO;
import org.apache.ozhera.log.manager.model.dto.GraphTypeDTO;
import org.apache.ozhera.log.manager.model.dto.LogAnalyseDataDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAnalyseDashboardDO;
import org.apache.ozhera.log.manager.model.pojo.MilogAnalyseDashboardGraphRefDO;
import org.apache.ozhera.log.manager.model.pojo.MilogAnalyseGraphDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.vo.CreateDashboardCmd;
import org.apache.ozhera.log.manager.model.vo.CreateGraphCmd;
import org.apache.ozhera.log.manager.model.vo.DGRefCmd;
import org.apache.ozhera.log.manager.model.vo.DGRefDelCmd;
import org.apache.ozhera.log.manager.model.vo.DGRefUpdateCmd;
import org.apache.ozhera.log.manager.model.vo.GraphQuery;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseDataPreQuery;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseDataQuery;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseQuery;
import org.apache.ozhera.log.manager.model.vo.UpdateGraphCmd;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogAnalyseService {
    private static final Logger log = LoggerFactory.getLogger(LogAnalyseService.class);
    @Resource
    private MilogAnalyseDashboardGraphRefMapper dgRefMapper;
    @Resource
    private MilogAnalyseDashboardMapper dashboardMapper;
    @Resource
    private MilogAnalyseGraphMapper graphMapper;
    @Resource
    private MilogAnalyseGraphTypeMapper graphTypeMapper;
    @Resource
    private AnalyseLog analyseLog;
    @Resource
    private MilogLogstoreDao logstoreDao;
    private static final List<String> ignoreKeyList = new ArrayList<String>();

    public LogAnalyseService() {
        ignoreKeyList.add("message");
        ignoreKeyList.add("logsource");
        ignoreKeyList.add("timestamp");
        ignoreKeyList.add("traceId");
        ignoreKeyList.add("line");
    }

    public Result<DashboardDTO> getDashboardGraph(LogAnalyseQuery logAnalyseQuery) {
        List<MilogAnalyseDashboardDO> dashboardList = this.dashboardMapper.getByStoreId(logAnalyseQuery.getStoreId());
        if (dashboardList == null || dashboardList.isEmpty()) {
            return Result.success();
        }
        MilogAnalyseDashboardDO dashboard = dashboardList.get(0);
        List<DashboardGraphDTO> dashboardGraphList = this.graphMapper.getDashboardGraph(dashboard.getId());
        return Result.success((Object)DashboardConvert.INSTANCE.fromDO(dashboard, dashboardGraphList));
    }

    public Result<Long> createGraph(CreateGraphCmd cmd) {
        MilogAnalyseGraphDO graphDO = GraphConvert.INSTANCE.toDO(cmd);
        graphDO.setCreator(MoneUserContext.getCurrentUser().getUser());
        graphDO.setUpdater(MoneUserContext.getCurrentUser().getUser());
        long thisTime = System.currentTimeMillis();
        graphDO.setCreateTime(thisTime);
        graphDO.setUpdateTime(thisTime);
        this.graphMapper.insert(graphDO);
        return Result.success((Object)graphDO.getId());
    }

    public Result<Boolean> updateGraph(UpdateGraphCmd cmd) {
        MilogAnalyseGraphDO graphDO = GraphConvert.INSTANCE.toDO(cmd);
        graphDO.setUpdater(MoneUserContext.getCurrentUser().getUser());
        graphDO.setUpdateTime(System.currentTimeMillis());
        int res = this.graphMapper.updateById(graphDO);
        return res == 1 ? Result.success((Object)true) : Result.fail((CommonError)CommonError.ParamsError);
    }

    public Result<Boolean> deleteGraph(Long graphId) {
        this.graphMapper.deleteById(graphId);
        this.dgRefMapper.deleteGraphRef(graphId);
        return Result.success((Object)true);
    }

    public Result<List<GraphDTO>> searchGraph(GraphQuery query) {
        List<GraphDTO> graphList = this.graphMapper.search(query);
        return Result.success(graphList);
    }

    public Result<Boolean> ref(DGRefCmd cmd) {
        Long refed = this.dgRefMapper.isRefed(cmd.getDashboardId(), cmd.getGraphId());
        if (refed == null || refed == 0L) {
            int res = this.dgRefMapper.insert(DGRefConvert.INSTANCE.toDo(cmd));
            return res == 1 ? Result.success((Object)true) : Result.fail((CommonError)CommonError.ParamsError);
        }
        return Result.fail((Integer)CommonError.ParamsError.getCode(), (String)"The chart already exists for this dashboard");
    }

    public Result<Boolean> delRef(DGRefDelCmd cmd) {
        int res = this.dgRefMapper.delRef(cmd.getDashboardId(), cmd.getGraphId());
        return res == 1 ? Result.success((Object)true) : Result.fail((CommonError)CommonError.ParamsError);
    }

    public Result<Boolean> updateRef(DGRefUpdateCmd cmd) {
        if (cmd.getDashboardId() == null || cmd.getGraphList() == null || cmd.getGraphList().isEmpty()) {
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        for (DGRefUpdateCmd.DGRefDetailUpdateCmd graph : cmd.getGraphList()) {
            MilogAnalyseDashboardGraphRefDO refOld = this.dgRefMapper.getRef(cmd.getDashboardId(), graph.getGraphId());
            if (refOld == null) {
                return Result.fail((CommonError)CommonError.ParamsError);
            }
            MilogAnalyseDashboardGraphRefDO refNew = DGRefConvert.INSTANCE.toDo(graph);
            refNew.setId(refOld.getId());
            this.dgRefMapper.updateById(refNew);
        }
        return Result.success((Object)true);
    }

    public Result<LogAnalyseDataDTO> data(LogAnalyseDataQuery query) throws IOException {
        LogAnalyseDataDTO dto = this.analyseLog.getData(query);
        return Result.success((Object)dto);
    }

    public Result<LogAnalyseDataDTO> dataPre(LogAnalyseDataPreQuery query) throws IOException {
        LogAnalyseDataDTO dto = this.analyseLog.getData(query);
        return Result.success((Object)dto);
    }

    public Result<Long> createDashboard(CreateDashboardCmd cmd) {
        MilogAnalyseDashboardDO dashboardDO = DashboardConvert.INSTANCE.toDO(cmd);
        dashboardDO.setCreateTime(System.currentTimeMillis());
        dashboardDO.setCreator(MoneUserContext.getCurrentUser().getUser());
        MilogLogStoreDO logstore = this.logstoreDao.queryById(cmd.getStoreId());
        if (logstore == null) {
            return Result.failParam((String)"Create failed, logstore does not exist");
        }
        dashboardDO.setName(logstore.getLogstoreName() + "dashboard");
        this.dashboardMapper.insert(dashboardDO);
        return Result.success((Object)dashboardDO.getId());
    }

    public Result<List<GraphTypeDTO>> type() {
        List gtaphTypeDOList = this.graphTypeMapper.selectList(null);
        List<GraphTypeDTO> graphTypeDTOList = GraphTypeConvert.INSTANCE.toDTOList(gtaphTypeDOList);
        return Result.success(graphTypeDTOList);
    }

    public Result<List<String>> supportKey(Long storeId) {
        if (storeId == null) {
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        MilogLogStoreDO logStore = this.logstoreDao.queryById(storeId);
        if (logStore == null) {
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        String[] keyDescripArray = logStore.getKeyList().split(",");
        ArrayList<String> keyList = new ArrayList<String>();
        for (String keyDes : keyDescripArray) {
            String key = keyDes.split(":")[0];
            if (ignoreKeyList.contains(key)) continue;
            keyList.add(key);
        }
        return Result.success(keyList);
    }
}

