/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.store;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ozhera.log.manager.model.dto.LogStorageData;

public interface LogStorageService {
    public static final String DORIS_TABLE_PREFIX = "hera_log_doris_table";
    public static final String BIGINT = "BIGINT";
    public static final String VARCHAR = "VARCHAR(1024)";
    public static final String VARCHAR_LARGE = "STRING";
    public static final List<String> Large_Field_Properties = Lists.newArrayList((Object[])new String[]{"message", "logsource"});

    public boolean createTable(LogStorageData var1);

    public boolean updateTable(LogStorageData var1);

    public boolean deleteTable(LogStorageData var1);

    public List<String> getColumnList(Long var1, String var2);

    default public String buildTableName(Long clusterId, Long storeId) {
        return String.format("%s_%s_%s", DORIS_TABLE_PREFIX, clusterId, storeId);
    }

    default public Map<String, String> buildFieldMap(String keys, String columnTypes) {
        List cleanKeyList = Arrays.stream(keys.split(",")).map(s -> s.split(":")[0]).collect(Collectors.toList());
        List<String> columnTypeList = Arrays.asList(columnTypes.split(","));
        return IntStream.range(0, cleanKeyList.size()).boxed().collect(Collectors.toMap(i -> (String)cleanKeyList.get((int)i), i -> this.mapFieldType(((String)columnTypeList.get((int)i)).toLowerCase(), (String)cleanKeyList.get((int)i))));
    }

    default public String mapFieldType(String fieldType, String field) {
        if (Large_Field_Properties.contains(field)) {
            return VARCHAR_LARGE;
        }
        switch (fieldType) {
            case "date": 
            case "long": {
                return BIGINT;
            }
            case "keyword": 
            case "text": 
            case "ip": {
                return VARCHAR;
            }
        }
        return fieldType;
    }
}

