/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.bind;

import cn.hutool.core.util.ClassUtil;
import com.xiaomi.youpin.docean.anno.Component;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.mapper.MilogLogTemplateMapper;
import org.apache.ozhera.log.manager.service.bind.ConfigLogTypeProcessor;
import org.apache.ozhera.log.manager.service.bind.DataSourceLogTypeProcessor;
import org.apache.ozhera.log.manager.service.bind.LogTypeProcessor;
import org.apache.ozhera.log.manager.service.bind.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Component
public class LogTypeProcessorFactory {
    private static final ConcurrentHashMap<String, LogTypeProcessor> SPI_LOG_MAP = new ConcurrentHashMap();
    private Config config = Config.ins();
    private MilogLogTemplateMapper milogLogTemplateMapper;

    public LogTypeProcessor getLogTypeProcessor() {
        if (SPI_LOG_MAP.isEmpty()) {
            Class<?> logTypeProcessor = LogTypeProcessorFactory.getTypeProcessor(LogTypeProcessor.class);
            LogTypeProcessor processor = this.createLogTypeProcessor(logTypeProcessor, this.config, this.milogLogTemplateMapper);
            SPI_LOG_MAP.putIfAbsent(logTypeProcessor.getClass().getName(), processor);
        }
        if (SPI_LOG_MAP.isEmpty()) {
            throw new MilogManageException("LogTypeProcessor not exist");
        }
        return SPI_LOG_MAP.values().stream().findAny().get();
    }

    private LogTypeProcessor createLogTypeProcessor(Class<?> logTypeProcessor, Config config, MilogLogTemplateMapper milogLogTemplateMapper) {
        if (Objects.equals(logTypeProcessor.getName(), ConfigLogTypeProcessor.class.getName())) {
            return new ConfigLogTypeProcessor(config);
        }
        if (Objects.equals(logTypeProcessor.getName(), DataSourceLogTypeProcessor.class.getName())) {
            if (null == milogLogTemplateMapper) {
                throw new MilogManageException("logTemplateMapper is null");
            }
            return new DataSourceLogTypeProcessor(milogLogTemplateMapper);
        }
        throw new MilogManageException("Unknown LogTypeProcessor class: " + logTypeProcessor.getName());
    }

    @Nullable
    private static Class<?> getTypeProcessor(Class<LogTypeProcessor> typeProcessorClass) {
        List classList = LogTypeProcessorFactory.getClasses(typeProcessorClass).stream().filter(processorClass -> {
            Processor processor = processorClass.getAnnotation(Processor.class);
            return null != processor && processor.isDefault();
        }).sorted(Comparator.comparingInt(o -> o.getAnnotation(Processor.class).order())).collect(Collectors.toList());
        return (Class)classList.stream().findFirst().get();
    }

    @NotNull
    private static List<Class<?>> getClasses(Class<LogTypeProcessor> LogTypeProcessorClass) {
        Set classSet = ClassUtil.scanPackage((String)"org.apache.ozhera.log.manager");
        List<Class<?>> classes = classSet.parallelStream().filter(LogTypeProcessorClass::isAssignableFrom).filter(clazz -> !Objects.equals(clazz, LogTypeProcessorClass)).collect(Collectors.toList());
        return classes;
    }

    public void setMilogLogTemplateMapper(MilogLogTemplateMapper milogLogTemplateMapper) {
        this.milogLogTemplateMapper = milogLogTemplateMapper;
    }
}

