/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.api.model.dto.TraceLogDTO;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.domain.ClusterIndexVO;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.mapper.MilogEsIndexMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogEsIndexDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class TraceLog {
    private static final Logger log = LoggerFactory.getLogger(TraceLog.class);
    private static final String TIME_STAMP = "timestamp";
    @Resource
    private EsCluster esCluster;
    @Resource
    private MilogEsIndexMapper esIndexMapper;
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private MilogLogTailDao logTailDao;

    public TraceLogDTO getTraceLog(Long appId, String traceId, String region, String generationTime, String level) throws IOException {
        List<ClusterIndexVO> clusterIndexVOS;
        if (StringUtils.isEmpty((String)traceId)) {
            return null;
        }
        SearchSourceBuilder qb = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = this.getBoolQueryBuilder(appId, traceId, generationTime, level);
        qb.query((QueryBuilder)queryBuilder);
        if (null != appId) {
            clusterIndexVOS = this.logStoreDao.queryClusterIndexByAppId(appId);
        } else {
            List<MilogEsIndexDO> indexList = StringUtils.isEmpty((String)region) ? this.esIndexMapper.selectAreaIndexList("cn") : this.esIndexMapper.selectRegionIndexList(region);
            if (indexList == null || indexList.isEmpty()) {
                return TraceLogDTO.emptyData();
            }
            clusterIndexVOS = indexList.stream().map(MilogEsIndexDO::toClusterIndexVO).distinct().collect(Collectors.toList());
        }
        return this.EsAsyncSearch(clusterIndexVOS, qb);
    }

    @NotNull
    private BoolQueryBuilder getBoolQueryBuilder(Long appId, String traceId, String generationTime, String level) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        List<Long> tailIds = this.queryTailIdByAppId(appId);
        queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"traceId", (String)traceId));
        if (StringUtils.isNotBlank((String)level)) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"level", (String)level));
        }
        if (CollectionUtils.isNotEmpty(tailIds)) {
            queryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"tailId", tailIds));
        }
        if (StringUtils.isNotEmpty((String)generationTime)) {
            long time = new DateTime((CharSequence)generationTime).getTime();
            long startTime = time - TimeUnit.HOURS.toMillis(1L);
            long endTime = time + TimeUnit.HOURS.toMillis(1L);
            queryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TIME_STAMP).from((Object)startTime).to((Object)endTime));
        }
        return queryBuilder;
    }

    private List<Long> queryTailIdByAppId(Long appId) {
        List<MilogLogTailDo> logTailDos = this.logTailDao.queryByAppId(appId);
        if (CollectionUtils.isNotEmpty(logTailDos)) {
            return logTailDos.stream().map(MilogLogTailDo::getId).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public TraceLogDTO EsAsyncSearch(List<ClusterIndexVO> indexList, SearchSourceBuilder qb) {
        CountDownLatch countDownLatch = new CountDownLatch(indexList.size());
        AsyncSearchObj asyncSearchObj = new AsyncSearchObj(this, countDownLatch);
        for (ClusterIndexVO esIndexDO : indexList) {
            EsService esService = this.esCluster.getEsService(esIndexDO.getClusterId());
            if (esService == null) {
                countDownLatch.countDown();
                log.warn("[Esdata.getTraceLog] es client [{}] is not generated", (Object)(Constant.LOG_STORAGE_SERV_BEAN_PRE + esIndexDO.getClusterId()));
                continue;
            }
            SearchRequest searchRequest = new SearchRequest(new String[]{esIndexDO.getIndexName()});
            searchRequest.source(qb);
            esService.searchAsync(searchRequest, asyncSearchObj.getListenerStack().pop());
        }
        try {
            countDownLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Log query error, query trace log error countdownlatch timeout, error is [{}]", (Object)e.getMessage(), (Object)e);
        }
        Set<String> logSet = asyncSearchObj.getLogSet();
        return new TraceLogDTO(this.sortedLogWithTime(logSet));
    }

    @Nullable
    private Set<String> sortedLogWithTime(Set<String> logSet) {
        if (CollectionUtils.isNotEmpty(logSet)) {
            logSet = logSet.stream().sorted((o1, o2) -> {
                try {
                    JSONObject obj1 = JSON.parseObject((String)String.valueOf(o1));
                    JSONObject obj2 = JSON.parseObject((String)String.valueOf(o2));
                    if (obj1.getLong(TIME_STAMP) == null) {
                        return 1;
                    }
                    if (obj2.getLong(TIME_STAMP) == null) {
                        return -1;
                    }
                    return obj2.getLong(TIME_STAMP).compareTo(obj1.getLong(TIME_STAMP));
                }
                catch (Exception e) {
                    log.error("compare exception", (Throwable)e);
                    return 0;
                }
            }).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return logSet;
    }

    private class AsyncSearchObj {
        private Set<String> logSet;
        private Stack<ActionListener<SearchResponse>> listenerStack = new Stack();

        public AsyncSearchObj(final TraceLog traceLog, final CountDownLatch countDownLatch) {
            this.logSet = Collections.synchronizedSet(new TreeSet<String>(new Comparator<String>(){
                Gson gson = new Gson();

                @Override
                public int compare(String o1, String o2) {
                    if (((Map)this.gson.fromJson(o1, Map.class)).get(TraceLog.TIME_STAMP) == null) {
                        return 1;
                    }
                    if (((Map)this.gson.fromJson(o2, Map.class)).get(TraceLog.TIME_STAMP) == null) {
                        return -1;
                    }
                    int res = (int)(Double.parseDouble(String.valueOf(((Map)this.gson.fromJson(o1, Map.class)).get(TraceLog.TIME_STAMP))) - Double.parseDouble(String.valueOf(((Map)this.gson.fromJson(o2, Map.class)).get(TraceLog.TIME_STAMP))));
                    if (res == 0) {
                        return 1;
                    }
                    return res;
                }
            }));
            int i = 0;
            while ((long)i < countDownLatch.getCount()) {
                ActionListener<SearchResponse> listener = new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse searchResponse) {
                        SearchHit[] hits = searchResponse.getHits().getHits();
                        if (hits == null || hits.length == 0) {
                            countDownLatch.countDown();
                            return;
                        }
                        for (SearchHit hit : hits) {
                            AsyncSearchObj.this.logSet.add(hit.getSourceAsString());
                        }
                        countDownLatch.countDown();
                    }

                    public void onFailure(Exception e) {
                        countDownLatch.countDown();
                        log.error("[Esdata.getTraceLog] search has failure, error is [{}]", (Object)e.getMessage());
                    }
                };
                this.listenerStack.push(listener);
                ++i;
            }
        }

        public Set<String> getLogSet() {
            return this.logSet;
        }

        public Stack<ActionListener<SearchResponse>> getListenerStack() {
            return this.listenerStack;
        }

        public void setLogSet(Set<String> logSet) {
            this.logSet = logSet;
        }

        public void setListenerStack(Stack<ActionListener<SearchResponse>> listenerStack) {
            this.listenerStack = listenerStack;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncSearchObj)) {
                return false;
            }
            AsyncSearchObj other = (AsyncSearchObj)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$logSet = this.getLogSet();
            Set<String> other$logSet = other.getLogSet();
            if (this$logSet == null ? other$logSet != null : !((Object)this$logSet).equals(other$logSet)) {
                return false;
            }
            Stack<ActionListener<SearchResponse>> this$listenerStack = this.getListenerStack();
            Stack<ActionListener<SearchResponse>> other$listenerStack = other.getListenerStack();
            return !(this$listenerStack == null ? other$listenerStack != null : !((Object)this$listenerStack).equals(other$listenerStack));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsyncSearchObj;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $logSet = this.getLogSet();
            result = result * 59 + ($logSet == null ? 43 : ((Object)$logSet).hashCode());
            Stack<ActionListener<SearchResponse>> $listenerStack = this.getListenerStack();
            result = result * 59 + ($listenerStack == null ? 43 : ((Object)$listenerStack).hashCode());
            return result;
        }

        public String toString() {
            return "TraceLog.AsyncSearchObj(logSet=" + String.valueOf(this.getLogSet()) + ", listenerStack=" + String.valueOf(this.getListenerStack()) + ")";
        }
    }
}

