/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.dao;

import com.xiaomi.youpin.docean.anno.Service;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.model.convert.MilogSpaceConvert;
import org.apache.ozhera.log.manager.model.dto.MilogSpaceDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.apache.ozhera.log.manager.user.MoneUser;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.pager.Pager;

@Service
public class MilogSpaceDao {
    @Resource
    private NutDao dao;

    public MilogSpaceDO newMilogSpace(MilogSpaceDO ms) {
        MilogSpaceDO ret = (MilogSpaceDO)this.dao.insert((Object)ms);
        return ret;
    }

    public MilogSpaceDO insert(MilogSpaceDO spaceDO) {
        return (MilogSpaceDO)this.dao.insert((Object)spaceDO);
    }

    public MilogSpaceDO queryById(Long id) {
        return (MilogSpaceDO)this.dao.fetch(MilogSpaceDO.class, id.longValue());
    }

    public List<MilogSpaceDO> queryBySpaceName(String spaceName) {
        return this.dao.query(MilogSpaceDO.class, (Condition)Cnd.where((String)"space_name", (String)"=", (Object)spaceName));
    }

    public boolean updateMilogSPace(Long id, Long tenantId, String spaceName, String description) {
        Chain chain = Chain.make((String)"tenant_id", (Object)tenantId).add("space_name", (Object)spaceName).add("description", (Object)description);
        chain.add("utime", (Object)Instant.now().toEpochMilli());
        int ret = this.dao.update(MilogSpaceDO.class, chain, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return ret == 1;
    }

    public boolean update(MilogSpaceDO milogSpace) {
        return this.dao.update((Object)milogSpace) == 1;
    }

    public boolean deleteMilogSpace(Long id) {
        int ret = this.dao.clear(MilogSpaceDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return ret == 1;
    }

    public List<MilogSpaceDO> getSpaceByIdList(List<Long> ids) {
        return this.dao.query(MilogSpaceDO.class, (Condition)Cnd.where((String)"id", (String)"in", ids));
    }

    public List<MilogSpaceDO> getMilogSpaces(String limitDeptId) {
        Cnd cnd = Cnd.NEW();
        MoneUser currentUser = MoneUserContext.getCurrentUser();
        if (!currentUser.getIsAdmin().booleanValue() && StringUtils.isNotEmpty((CharSequence)currentUser.getZone())) {
            cnd.and("perm_dept_id", "like", (Object)("%" + limitDeptId + "%")).or("creator", "=", (Object)"system");
        }
        cnd.orderBy("ctime", "desc");
        return this.dao.query(MilogSpaceDO.class, (Condition)cnd);
    }

    public MilogSpaceDO getMilogSpaceById(Long id) {
        List milogSpaces = this.dao.query(MilogSpaceDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)milogSpaces)) {
            return (MilogSpaceDO)milogSpaces.get(milogSpaces.size() - 1);
        }
        return null;
    }

    public boolean verifyExistByName(String spaceName) {
        int count = this.dao.count(MilogSpaceDO.class, (Condition)Cnd.where((String)"space_name", (String)"=", (Object)spaceName));
        return count > 0;
    }

    public boolean verifyExistByName(String spaceName, Long id) {
        List ret = this.dao.query(MilogSpaceDO.class, (Condition)Cnd.where((String)"space_name", (String)"=", (Object)spaceName));
        for (int i = 0; i < ret.size(); ++i) {
            if (((MilogSpaceDO)ret.get(i)).getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getMilogSpaceByPage(String spaceName, List<Long> permSpaceIdList, int page, int pagesize) {
        Cnd cnd = StringUtils.isNotEmpty((CharSequence)spaceName) ? Cnd.where((String)"space_name", (String)"like", (Object)("%" + spaceName + "%")) : Cnd.NEW();
        MoneUser currentUser = MoneUserContext.getCurrentUser();
        if (!currentUser.getIsAdmin().booleanValue() && StringUtils.isNotEmpty((CharSequence)currentUser.getZone())) {
            cnd.and("id", "in", permSpaceIdList).or("creator", "=", (Object)"system");
        }
        List ret = this.dao.query(MilogSpaceDO.class, (Condition)cnd.orderBy("ctime", "desc"), new Pager(page, pagesize));
        List<MilogSpaceDTO> dtoList = MilogSpaceConvert.INSTANCE.fromDOList(ret);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("list", dtoList);
        result.put("total", this.dao.count(MilogSpaceDO.class, (Condition)cnd));
        result.put("page", page);
        result.put("pageSize", pagesize);
        return result;
    }

    public List<MilogSpaceDO> getAll() {
        return this.dao.query(MilogSpaceDO.class, null);
    }

    public List<MilogSpaceDO> queryByIds(List<Long> spaceIds) {
        Cnd cnd = Cnd.where((String)"id", (String)"in", spaceIds);
        return this.dao.query(MilogSpaceDO.class, (Condition)cnd);
    }

    public List<MilogSpaceDO> queryByName(String name) {
        Cnd cnd = Cnd.NEW();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            cnd = Cnd.where((String)"space_name", (String)"like", (Object)("%" + name + "%"));
        }
        return this.dao.query(MilogSpaceDO.class, (Condition)cnd);
    }
}

